extends World

@onready var map: TBLoader = $NavigationRegion3D/Map
var expected_enemy_groups: Array = ["mooks", "punks", "burglars", "clowns_freeling", "wiseguys"]
var total_enemies: int
var debug_store: Dictionary = {"node_counter": {}}
var total_time: float = 0.0
var is_exit_triggered: bool = false
var is_club_music_triggered: bool = false
var is_cinem_clown_vest_triggered: bool = false

var intermission_loop_scene: Resource = preload("res://Scenes/intermission_loop.tscn")
var full_init: bool = false

var is_exit_camera_flickering: bool = false
var exit_camera_delta: float = 0.0
var exit_camera_interval: float = .001
var exit_camera_index: int = 0
@onready var exit_cameras: Array = [
	$External/Exit/exit_camera_1,
	$External/Exit/exit_camera_2
]
@onready var exit_player_pos: Marker3D = $External/Exit/exit_player_pos
@onready var exit_light: Node3D = $External/Exit/exit_light
@onready var exit_music: AudioStreamPlayer3D = $External/Exit/exit_music
@onready var exit_screen: Control = $External/Exit/exit_screen
var keep_player_inventory: bool = true
var game_tree: Control

func _enter_tree() -> void:
	windows_crash_fix()
	return

func _ready():
	game_tree = get_tree().get_first_node_in_group("game_tree")
	if game_tree:
		play_session_message()
	
	for c in get_tree().get_nodes_in_group("world_inits"):
		c._on_world_ready()
	
	if keep_player_inventory and not Global.prop_table["slot_manager_cache"].is_empty():
		U.grptop("players").load_saved_inventory()
		U.grptop("players").load_life_state()
	
	for enemy_group in expected_enemy_groups:
		total_enemies += len(get_tree().get_nodes_in_group(enemy_group))
	
	await get_tree().create_timer(.5).timeout
	full_init = true
	
	return

func _physics_process(delta):
	if not full_init: return
	
	total_time += delta
	
	return

# 

func exit_level():
	if is_exit_triggered:
		return
	
	is_exit_triggered = true
	Engine.time_scale = 0.4 # .2
	var player: Node3D = U.grptop("players")
	player.exit_mode = true
	player.hud.visible = false
	player.velocity = Vector3.ZERO
	player.toggle_dancing()
	
	player.global_position = exit_player_pos.global_position
	player.global_rotation = exit_player_pos.global_rotation
	
	#U.grptop("players").global_position = $External/Exit/exit_player_pos.global_position
	#U.grptop("players").global_rotation = $External/Exit/exit_player_pos.global_rotation
	for camera in exit_cameras:
		var prev_pos: Vector3 = camera.global_position
		camera.reparent(
			get_tree().get_first_node_in_group("exit_elevator")
		)
		
		#camera.global_position = prev_pos
	
	exit_light.get_node("AnimationPlayer").play("flash")
	exit_light.get_node("AnimationPlayer").speed_scale = 2.0
	exit_music.play(41.9)
	is_exit_camera_flickering = true
	await get_tree().create_timer(0.3).timeout
	#$External/Exit/exit_screen.visible = true
	trigger_exit_canvas()
	await get_tree().create_timer(25.0).timeout
	is_exit_camera_flickering = false
	get_tree().get_first_node_in_group("black_camera").make_current()

	return


func _on_exit_trigger_body_entered(body):
	if is_exit_triggered:
		return
	if not body.is_in_group("players"):
		return
	
	exit_level()
	return

func trigger_exit_canvas():
	exit_screen.visible = true
	var enemies_alive: int = 0
	for enemy_group in expected_enemy_groups:
		for enemy in get_tree().get_nodes_in_group(enemy_group):
			if not enemy.is_dead:
				enemies_alive += 1
	
	var total_kills: String = str(total_enemies - enemies_alive)
	var credits_amount: String = "0"
	if Global.prop_table["credits"].has(get_tree().get_first_node_in_group("players").offline_id):
		credits_amount = str(Global.prop_table["credits"][get_tree().get_first_node_in_group("players").offline_id])
	#var exit_screen: Control = $External/Exit/exit_screen
	exit_screen.get_node("Label_Kills").text = "KILLS: " + total_kills + " / " + str(total_enemies)
	exit_screen.get_node("Label_Time").text = "TIME: " + str(snappedf(total_time, 0.1))
	exit_screen.get_node("Label_Credits").text = "CREDS: " + credits_amount
	exit_screen.get_node("Label_Time").visible = true
	exit_screen.get_node("Label_Kills").visible = true
	exit_screen.get_node("Label_Credits").visible = true
	return

func show_session_control():
	$Control.visible = true
	return
	
func hide_session_control():
	$Control/AnimationPlayer.play("fade_out")
	#$Control.visible = false
	return

func env_fade_in():
	$WorldEnvironment/AnimationPlayer.play("fade_in")
	return

func env_fade_out():
	$WorldEnvironment/AnimationPlayer.play("fade_out")
	return

func play_session_message():
	env_fade_in()
	show_session_control()
	hide_session_control()
	return

func windows_crash_fix():
	Blackboard.actors.clear()
	Blackboard.current_world = self
	
	if not Global.is_iid_persistent:
		Global.reset_iid_table()
	
	self.add_to_group("Worlds")
	return
