extends Node3D

@onready var die_timer: Timer = $die_timer
@onready var anim: AnimationPlayer = $AnimationPlayer
var eject_anims: Array[String] = ["eject", "eject_2", "eject_3"]
@export var is_cache_item: bool = false

func _ready():
	if not is_cache_item:
		die_timer.start()
		await die_timer.timeout
		queue_free()
	return

func eject_random():
	anim.play(U.random_choice(eject_anims))
	return

func eject(variation_index: int = 0):
	anim.play(eject_anims[variation_index])
	return
