extends Control

var selected_map: String = ""
#var selected_map: String = "/home/u98/Documents/Projects/Trenchbroom/nmd_custom_map_test.map"
var previous_mouse_mode: int

func _on_map_location_button_pressed():
	$dialogs/map_location_dialog.visible = true
	return


func _on_map_location_dialog_file_selected(path):
	prints(self.name, "map file selected:", path)
	selected_map = path
	return


func _on_launch_map_pressed():
	var tbloader: TBLoader = get_tree().get_first_node_in_group("custom_tbloader")
	tbloader.map_resource = selected_map
	#tbloader.texture_path = selected_map.replace(
		#selected_map.split("/")[-1], "textures/"
	#)
	tbloader.texture_path = "res://custom_maps/textures"
	
	#tbloader.build_meshes()
	tbloader._build_wrapper()
	tbloader.get_parent().bake_navigation_mesh()
	get_tree().get_first_node_in_group("players").global_position = tbloader.global_position
	
	deactivate(true)
	
	return

func activate():
	previous_mouse_mode = Input.mouse_mode
	Input.mouse_mode = Input.MOUSE_MODE_VISIBLE
	self.visible = true
	var app_root: Control = get_tree().get_first_node_in_group("app_root")
	app_root.is_cursor_enabled = false
	return


func deactivate(release: bool = false):
	Input.mouse_mode = previous_mouse_mode
	self.visible = false
	var app_root: Control = get_tree().get_first_node_in_group("app_root")
	app_root.is_cursor_enabled = true
	
	if release:
		app_root.release()
		#await get_tree().create_timer(.5).timeout
		#get_tree().get_first_node_in_group("players").release_player_interface()
	return

func _on_quit_app_pressed():
	deactivate()
	return
