extends Control

# Coin screen
# Press to start
@onready var background: Node2D = $bg_scrolling
@onready var player: CharacterBody2D = $player_CRIMEBUSTER
@onready var sound_controller: Node = $sound_controller
var scroll_scale: float = -200.0
var scrollers: Array = []
var thug_res: Resource = preload("res://Scenes/Arcade/CRIMEBUSTER/thug_crimebuster.tscn")
var thugs_spawned: int = 0
var score: int = 0 :
	get:
		return score
	set(value):
		_score_changed(value)
		score = value
		return

var time: float = 0.0
var final_time: float = 0.0
var par_time: float = 20.00
var max_thugs_dead: int = 8
var is_game_ended: bool = false
var is_on_title_screen: bool = true
var world_instance: Node3D

func _ready():
	enable_title_screen()
	if Blackboard.current_world or get_tree().get_first_node_in_group("players"):
		disable_input()
		#disable_game()
	#else:
		#await get_tree().process_frame
		#enable_game()
	return

func enable_game():
	$virtualinput.disabled = false
	#$title_screen.visible = true
	#is_on_title_screen = true
	#$title_screen/banner/AnimationPlayer.play("start")
	
	scrollers.append(background)
	
	var thugs_at_start: Array = get_tree().get_nodes_in_group("arcade_thugs")
	#thugs_spawned = len(get_tree().get_nodes_in_group("arcade_thugs"))
	thugs_spawned = len(thugs_at_start)
	for thug in thugs_at_start:
		thug.died.connect(_on_thug_crimebuster_died)
	if len(get_tree().get_nodes_in_group("players")) > 0:
		thugs_spawned -= 1
	
	$score_labels/score_label_under.text = ""
	$end_overlay.visible = false
	$victory_screen.visible = false
	sound_controller.playsound("music")
	
	return

func disable_game():
	$virtualinput.disabled = true
	$title_screen.visible = false
	return

func _physics_process(delta):
	time += delta
	for scroller in scrollers:
		scroller.position.x = (player.position.x / self.size.x) * scroll_scale
	
	if is_game_ended:
		return
	
	$score_labels/score_label.text = str(score)
	
	var thugs_dead: int = 0
	for thug in get_tree().get_nodes_in_group("arcade_thugs"):
		if thug.is_dead:
			thugs_dead += 1
	$debug_label.text = str(time)
	if thugs_dead >= max_thugs_dead:
		trigger_victory()
	return


func _on_thug_crimebuster_died(caller):
	score += 50
	var score_bonus: int = 0
	score_bonus += int(caller.time_in_air)
	caller.reparent(background)
	spawn_control()
	return

func spawn_control():
	if thugs_spawned == 0:
		thugs_spawned = len(get_tree().get_nodes_in_group("arcade_thugs"))
	if thugs_spawned == 1:
		spawn_thug($thug_spawn_positions/thug_spawn_pos_1.global_position)
		return
	
	if thugs_spawned == 2:
		spawn_thug($thug_spawn_positions/thug_spawn_pos_2.global_position)
		spawn_thug($thug_spawn_positions/thug_spawn_pos_3.global_position)
		return
	
	if thugs_spawned == 3:
		spawn_thug($thug_spawn_positions/thug_spawn_pos_1.global_position)
		return
	
	if thugs_spawned == 4:
		spawn_thug($thug_spawn_positions/thug_spawn_pos_2.global_position)
		spawn_thug($thug_spawn_positions/thug_spawn_pos_3.global_position)
		spawn_thug($thug_spawn_positions/thug_spawn_pos_4.global_position)
		spawn_thug($thug_spawn_positions/thug_spawn_pos_1.global_position)
		return
	
	#if thugs_spawned == 6:
		#spawn_thug($thug_spawn_positions/thug_spawn_pos_1.global_position)
	return

func spawn_thug(spawn_pos: Vector2 = Vector2(-100, 0)):
	var new_thug: CharacterBody2D = thug_res.instantiate()
	new_thug.global_position = spawn_pos
	self.add_child(new_thug)
	new_thug.died.connect(_on_thug_crimebuster_died)
	thugs_spawned += 1
	return

func _score_changed(new_value: int):
	sound_controller.playsound("scoreplus")
	$score_labels/score_label_under.text = "+" + str(new_value)
	await get_tree().create_timer(.5).timeout
	$score_labels/score_label_under.text = ""
	return

func trigger_victory():
	is_game_ended = true
	final_time = time
	await get_tree().create_timer(1.0).timeout
	

	$virtualinput.current_user_anim = "arcade_box_idle"
	$virtualinput.disabled = true
	await get_tree().create_timer(.5).timeout
	$end_overlay.visible = true
	await get_tree().create_timer(.5).timeout
	$victory_screen.visible = true
	sound_controller.stop_all_sound()
	var score_iter_value: int = 50
	var score_iterations: int = int(score / score_iter_value)
	var score_counter: int = 0
	$victory_screen/final_score_label.text = str(score_counter)
	#var is_sound_playing: bool = false
	for i in range(score_iterations):
		if score_counter < score:
			score_counter += score_iter_value
		$victory_screen/final_score_label.text = str(score_counter)
		#is_sound_playing = !is_sound_playing
		#if is_sound_playing:
		sound_controller.playsound("scoreplus")
		await get_tree().create_timer(.1).timeout
	
	await get_tree().create_timer(1.0).timeout
	$victory_screen/time_score_label.text = "TIME BONUS"
	await get_tree().create_timer(1.0).timeout
	var time_bonus_score: int = int(par_time - final_time) * 5
	if time_bonus_score > 0:
		score += time_bonus_score
		$victory_screen/time_score_label.text = "+" + str(time_bonus_score)
		for i in range(time_bonus_score):
			if score_counter < score:
				score_counter += 1
			$victory_screen/final_score_label.text = str(score_counter)
			sound_controller.playsound("scoreplus")
			await get_tree().create_timer(.06).timeout
	elif time_bonus_score < 1:
		$victory_screen/time_score_label.text = "+ZERO"
	
	$victory_screen/time_score_label.text = ""
	
	$victory_screen/final_score_label.text = str(score)
	return

func leave_title_screen():
	$title_screen.visible = false
	is_on_title_screen = false
	enable_game()
	return

func enable_title_screen():
	$title_screen.visible = true
	is_on_title_screen = true
	$title_screen/banner/AnimationPlayer.play("start")
	return

func enable_input():
	$virtualinput.disabled = false
	return

func disable_input():
	$virtualinput.disabled = true
	return
