extends Node

const CFG_PATH: String = "user://config.gbin"
var session_cfg: Dictionary = {
	"cached": false
}

# Called when the node enters the scene tree for the first time.
func _ready():
	if not FileAccess.file_exists(CFG_PATH):
		FileAccess.open(CFG_PATH, FileAccess.WRITE).store_var(session_cfg)
	
	return

func reload_cfg():
	session_cfg = FileAccess.open(CFG_PATH, FileAccess.READ).get_var()
	return

func get_config_writable():
	var cfg_file: FileAccess = FileAccess.open(CFG_PATH, FileAccess.WRITE)
	return cfg_file

func set_prop(prop_key: String, prop_value: Variant):
	session_cfg["cached"] = true
	FileAccess.open(CFG_PATH, FileAccess.WRITE).store_var(session_cfg)
	return

func get_prop(prop_key: String):
	reload_cfg()
	return session_cfg[prop_key]
