extends StaticBody3D

var level_attempts: int = 3

func _init():
	self.add_to_group("interactables")
	return

func activate():
	var activation_successful: bool = false
	var top_node: Node3D
	for attempt in level_attempts:
		if not top_node:
			top_node = self.get_parent()
		if not top_node.has_method("activate"):
			top_node = top_node.get_parent()
			continue
		top_node.activate()
		activation_successful = true
		break
	return

func interact(_caller):
	activate()
	return
