extends RigidBody3D

var actor: Node3D
@export var collide_with_actors: bool = false
@export var collide_with_probes: bool = false
var ticker: float = 0.0
var tick_interval: float = .5
var viewtarget: PhysicsBody3D
var viewheight: float = 4.25
var viewexclusions: Array[RID]
var is_checking_viewtarget: bool = true

# Called when the node enters the scene tree for the first time.
func _ready() -> void:
	if not collide_with_actors:
		for world_actor in get_tree().get_nodes_in_group("actors"):
			self.add_collision_exception_with(actor)
	if not collide_with_probes:
		for world_probe in get_tree().get_nodes_in_group("ballprobes"):
			world_probe.add_collision_exception_with(self)
			self.add_collision_exception_with(world_probe)
	return


func _physics_process(delta: float) -> void:
	ticker += delta
	if ticker >= tick_interval:
		tick_control()
		ticker = 0.0
	
	return

func tick_control() -> void:
	if viewtarget and is_checking_viewtarget:
		var viewsource: Vector3 = self.global_position + Vector3(0, viewheight, 0)
		#var viewexclusions: Array[RID]
		if actor:
			if not actor in viewexclusions:
				viewexclusions.append(actor.get_rid())
			if actor.is_in_group("actors") and not actor.is_in_group("players"):
				var npc_group: String
				var all_actor_groups: Array = actor.get_groups()
				for actor_group in all_actor_groups:
					if actor_group == "hit_takers":
						continue
					if actor_group == "actors":
						continue
					npc_group = actor_group
					break
				if npc_group:
					for npc in get_tree().get_nodes_in_group(npc_group):
						if not viewexclusions.has(npc.get_rid()):
							viewexclusions.append(npc.get_rid())
		var viewresult: Dictionary = U.world_raycast(self, viewsource, viewtarget.global_position, viewexclusions)
		if viewresult.has("collider") and viewresult["collider"] == viewtarget:
			$debug_label.text = "c: " + str(viewresult["collider"].name)
			$mesh_red.visible = true
			$mesh_green.visible = false
		else:
			$debug_label.text = "c: " + "--"
			$mesh_red.visible = false
			$mesh_green.visible = true
	return

func get_viewtarget_collision() -> Object:
	if not (viewtarget and is_checking_viewtarget):
		return
	var viewsource: Vector3 = self.global_position + Vector3(0, viewheight, 0)
	var viewexclusions: Array[RID]
	if actor:
		viewexclusions.append(actor.get_rid())
	var viewresult: Dictionary = U.world_raycast(self, viewsource, viewtarget.global_position, viewexclusions)
	if viewresult.has("collider"):
		return viewresult["collider"]
	else:
		return null
	
