extends StaticBody3D

@export var health: int = 5 :
	get:
		return health
	set(value):
		health = value
		if death_check():
			die()
#@onready var bottle_break_effect_scene: Packed
var default_groups: Array = [
	"breakables",
	"hit_takers",
	"mod_interactables"
]
const bottle_break_effect: Resource = preload("res://Scenes/bottle_break_effect.tscn")
var last_hit_pos: Vector3
var mesh_node: MeshInstance3D
var bottle_root: Node3D
var bottle_props: Dictionary

func _ready():
	for g in default_groups:
		self.add_to_group(g)
	await get_tree().process_frame
	bottle_root = self.get_parent()
	bottle_props = U.read_propstring(bottle_root.name)
	return

func death_check():
	if health < 1:
		return true
	elif health > 0:
		return false
	return

func mod_interact(caller: Node3D):
	world_pickup(caller)
	return

func world_pickup(caller: Node3D):
	for g in default_groups:
		self.remove_from_group(g)
	
	set_mesh_node()
	var world_pickup_payload: Dictionary = {
		"item": "bottleitem",
		"props": bottle_props,
		"node": mesh_node
	}
	var assumed_root_item_duplicate: Node3D = self.get_parent().duplicate()
	assumed_root_item_duplicate.process_mode = Node.PROCESS_MODE_DISABLED
	world_pickup_payload["props"]["assumed_root_item"] = assumed_root_item_duplicate
	world_pickup_payload["props"]["kill_callback"] = U.spawn_bottle_break.bind(last_hit_pos, bottle_props)
	world_pickup_payload["props"]["item"] = world_pickup_payload["item"]
	caller.receive_world_pickup(world_pickup_payload)
	self.queue_free()
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	if hit_pos:
		last_hit_pos = hit_pos
	else:
		last_hit_pos = self.global_position
	if death_check(): return
	
	var is_regular_hit: bool = (
		hit_type == U.hit_types.UNDEFINED or \
		hit_type == U.hit_types.RAYCAST or \
		hit_type == U.hit_types.AREA
	)
	#if hit_type == U.hit_types.UNDEFINED:
	if is_regular_hit:
		health -= damage
	elif hit_type == U.hit_types.KICK:
		health -= damage
	else:
		prints(self.name, "called hit() with an uncoded hit type")
		U.spawn_green_marker(Blackboard.current_world, self.global_position, 999.0)
	return


func die():
	var world_effect: Node3D = bottle_break_effect.instantiate()
	Blackboard.current_world.add_child(world_effect)
	world_effect.global_position = last_hit_pos
	if bottle_props.has("bottletype") and bottle_props["bottletype"] == "ketchup":
		world_effect.is_ketchup = true
	world_effect.activate()
	
	set_mesh_node()
	mesh_node.visible = false
	var colshape: CollisionShape3D = self.find_children("*", "CollisionShape3D").front()
	colshape.disabled = true
	await get_tree().create_timer(world_effect.time_to_die).timeout
	#await get_tree().process_frame
	
	mesh_node.queue_free()
	self.queue_free()
	return

func die_no_deps(effect_position: Vector3, effect_props: Dictionary):
	
	var world_effect: Node3D = load("res://Scenes/bottle_break_effect.tscn").instantiate()
	Blackboard.current_world.add_child(world_effect)
	world_effect.global_position = effect_position
	if effect_props.has("bottletype") and effect_props["bottletype"] == "ketchup":
		world_effect.is_ketchup = true
	world_effect.activate()
	return

func set_mesh_node():
	if not mesh_node:
		var parent: Node3D = self.get_parent()
		var mesh_candidates: Array = []
		for node_child in parent.get_children():
			if is_instance_of(node_child, MeshInstance3D):
				mesh_candidates.append(node_child)
		
		#mesh_node = get_parent().find_children("*", "MeshInstance3D").front()
		#mesh_node = parent.find_children("*", "MeshInstance3D").front()
		mesh_node = mesh_candidates.front()
	return
