extends StaticBody3D


# If activated, disable collider, change texture to break texture
## Actually, even lazier, just put the break brush inside of it in TB
## Make this just delete the unbroken brush

@export var is_hittable: bool = true
@export var health: int = 1
var is_dead: bool = false
var sounds: Dictionary = {
	"paper_ripped": preload("res://Audio/Paper Ripped - 1.mp3")
}
var activate_sound: AudioStreamPlayer3D

func _ready():
	self.add_to_group("breaktex_brushes")
	if is_hittable:
		self.add_to_group("hit_takers")
	
	if self.get_parent().name.contains("paperwall"):
		activate_sound = AudioStreamPlayer3D.new()
		activate_sound.volume_db = 25
		self.add_child(activate_sound)
		#activate_sound.global_position = self.global_position
		activate_sound.global_position = self.get_parent().global_position
		activate_sound.stream = sounds["paper_ripped"]
	return

func hit(damage: int = 1, hit_type: int = U.hit_types.UNDEFINED, caller: PhysicsBody3D = null, hit_pos: Vector3 = Vector3.ZERO):
	if is_dead:
		return
	health -= damage
	if health < 1:
		is_dead = true
		activate(self)
	return

func activate(_caller: Node = null):
	var parent: Node3D = self.get_parent()
	if parent.name.contains("-breaktex"):
		if activate_sound:
			activate_sound.reparent(Blackboard.current_world)
			activate_sound.play()
		
		parent.queue_free()
	return
