extends AnimatableBody3D

@onready var anim: AnimationPlayer = $burglar_turret/AnimationPlayer
@onready var eyes: Node3D = $mid_anchor/eyes
var health: int = 35
const BASE_SPEED: float = 11.0
var engage_distance: float = 25.0
var speed: float = BASE_SPEED
enum top_states {
	IDLE,
	PATROL,
	ALERT,
	ATTACK_INTENT,
	ATTACK_MELEE,
	ATTACK_SHOOT,
	DEAD,
	NONE
}
var top_state: int = top_states.IDLE
var previous_top_state: int = top_state
var active_target: PhysicsBody3D
###

var anim_set: Dictionary = {
	"idle": "unarmed_idle",
	"run": "unarmed_run",
	"die": "die_5"
}

func _ready():
	anim.play(anim_set["idle"])
	return

func _physics_process(delta):
	behavior_control()
	return

###

func behavior_control():
	match top_state:
		top_states.IDLE:
			if not active_target:
				update_active_target()
				return
			
			if active_target and A.is_actor_ahead_approx(self, active_target) and A.distance(self, active_target) < engage_distance:
				top_state_switch_to(top_states.ALERT)
			return
		top_states.PATROL:
			return
		top_states.ALERT:
			A.face_position(self, active_target.global_position)
			return
		top_states.ATTACK_INTENT:
			return
		top_states.ATTACK_MELEE:
			return
		top_states.ATTACK_SHOOT:
			return
		top_states.DEAD:
			return
		top_states.NONE:
			return
	return

func animation_control():
	return

func top_state_switch_to(new_state: int):
	previous_top_state = top_state
	top_state = new_state
	return

func update_active_target():
	var player: PhysicsBody3D = get_tree().get_first_node_in_group("players")
	if not player:
		return
	active_target = player
	return
