extends StaticBody3D

@onready var anim: AnimationPlayer = $cultist_creeper/AnimationPlayer
@onready var grab_area: Area3D = $cultist_creeper/Armature/Skeleton3D/BoneAttachment3D/grab_area
@onready var choke_pos: Marker3D = $choke_pos
var grabbing_range: float = 14.0 # 9.0 # 9.0 original, fast walking or running will pass too easily
var detected_player: PhysicsBody3D
var is_reaching_for_player: bool = false
var is_choking_player: bool = false
var is_player_grabbed: bool = false
var choke_damage: int = 8

var health: int = 1
var is_dead: bool = false

func _physics_process(_delta):
	if detected_player and detected_player.is_dead:
		return
	
	if is_reaching_for_player and not is_player_grabbed:
		if $give_up.is_stopped():
			return
		
		is_player_grabbed = detected_player in grab_area.get_overlapping_bodies()
		return
	return

func behavior_control():
	if is_player_grabbed:
		if not is_choking_player:
			anim.play("creeper_choke_1")
			is_choking_player = true
			choke_player()
			$choke_tick.start()
		return
	
	if is_reaching_for_player:
		if $give_up.is_stopped():
			return
		
		is_player_grabbed = detected_player in grab_area.get_overlapping_bodies()
		return
	
	# Is player in range?
	if not detected_player:
		detected_player = get_tree().get_first_node_in_group("players")
	
	var dist_to_player: float = self.global_position.distance_to(detected_player.global_position)
	if dist_to_player < grabbing_range:
		reach_for_player()
	# 	Reach for player
	# 	Detect if player grabbable
	#		Grab player
	return

func reach_for_player():
	anim.play("creeper_reach_start_1")
	anim.queue("creeper_reach_1")
	$creeper_whine.play()
	is_reaching_for_player = true
	$give_up.start()
	return

func _on_tick_timeout():
	behavior_control()
	return

func stop_reaching():
	$give_up.stop()
	await get_tree().create_timer(1.2).timeout
	$choke_tick.stop()
	anim.play_backwards("creeper_reach_start_1")
	anim.queue("cult_die")
	return

func _on_give_up_timeout():
	if not is_choking_player:
		stop_reaching()
	return

func choke_player():
	detected_player.choke_actor = self
	detected_player.choke_hit(choke_damage, U.hit_types.UNDEFINED, self, choke_pos.global_position)
	if detected_player.health < 0:
		is_choking_player = false
		is_player_grabbed = false
		stop_reaching()
	return

func _on_choke_tick_timeout():
	if is_choking_player:
		choke_player()
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	health -= damage
	if health < 0 and not is_dead:
		kill_actor()
	return

func kill_actor():
	is_dead = true
	$CollisionShape3D.disabled = true
	detected_player.choke_release()
	is_reaching_for_player = false
	is_choking_player = false
	is_player_grabbed = false
	for timer in self.find_children("*", "Timer"):
		timer.stop()
	stop_reaching()
	$creeper_whine.stop()
	$creeper_howl.play()
	return
