extends CharacterBody3D

# TODO
# - Make a function to hit the target (not just shoot towards)
# - Make a running toggle
# - Fix running anims

const SPEED = 5.0
const JUMP_VELOCITY = 4.5

@export var spawn_idle: bool = true
@export var health: int = 35

var gravity = (ProjectSettings.get_setting("physics/3d/default_gravity") * 6)

@onready var grunt_brain: Node = $grunt_brain
#@onready var grunt_rifle: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_rhand/anchor/debug_grunt_rifle # Temporary?
@onready var grunt_rifle: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_rhand/anchor/debug_grunt_rifle
@onready var anim: AnimationPlayer = $graphics/grunt/AnimationPlayer
@onready var hit_sound: AudioStreamPlayer3D = $Sound/hit_sound
@onready var rhand: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_rhand/anchor
@onready var lhand: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_lhand/anchor
@onready var eyes: Node3D = $eyes
@onready var anim_timer: Timer = $anim_timer
@onready var debug_label: Label3D = $debug_label

var ammo: int = 150

var anim_set: Dictionary = {
	"idle": "armed_idle",
	"aim": "armed_aim",
	"travel": "armed_run",
	"die": "die1"
}
var anim_locked: bool = false

enum armed_types {
	UNARMED,
	ARMED,
	AKIMBO
}
var armed_type: int = armed_types.UNARMED

var is_dead: bool = false
var last_anim: String

func ready():
	equip_grunt_rifle()
	return

func equip_grunt_rifle():
	return

func _physics_process(delta):
	apply_gravity(delta)
	
	move_and_slide()
	animate()
	#debug_label.text = "H: " + str(health) + " / A: " + str(ammo)

func apply_gravity(delta):
	# Add the gravity.
	if not is_on_floor():
		velocity.y -= gravity * delta
	return


func apply_jump():
	# Handle Jump.
	velocity.y = JUMP_VELOCITY
	return

func apply_move(input_dir: Vector2):
	# Get the input direction and handle the movement/deceleration.
	# As good practice, you should replace UI actions with custom gameplay actions.
	# var input_dir = Input.get_vector("ui_left", "ui_right", "ui_up", "ui_down")
	var direction = (transform.basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	if direction:
		velocity.x = direction.x * SPEED
		velocity.z = direction.z * SPEED
	else:
		velocity.x = move_toward(velocity.x, 0, SPEED)
		velocity.z = move_toward(velocity.z, 0, SPEED)
	return

func look_towards(target_position: Vector3, turn_speed: float):
	# This could probably be done with tween, without the eyes node
	eyes.look_at(target_position, Vector3.UP, true)
	self.rotation.x = (eyes.rotation.x * .9)
	self.rotate_y(eyes.rotation.y * turn_speed)
	return

func check_dead():
	return health < 0

func check_aiming():
	return grunt_brain.is_aiming

func check_traveling():
	return is_on_floor() and not velocity.is_zero_approx()

func animate():
	if is_dead: return
	
	var conditions: Dictionary = {
		"die": [
			check_dead()
		],
		"aiming": [
			check_aiming()
		],
		"idle": [
			is_on_floor(),
			velocity.is_zero_approx()
		],
		"travel": [
			check_traveling()
		]
	}
	
	var animate_condition: String
	for condition in conditions:
		var condition_met: bool = conditions[condition].all(U.is_true)
		if not condition_met:
			continue
		
		animate_condition = condition
		break
	
	match animate_condition:
		"aiming":
			anim_h(anim_set["aim"], true, 0.6)
		"die":
			anim_h(anim_set["die"], true)
			kill_actor()
		"idle":
			anim_h(anim_set["idle"])
		"travel":
			anim_h(anim_set["travel"])
	return

func set_armed_type(new_armed_type):
	match new_armed_type:
		armed_types.UNARMED:
			anim_set["idle"] = "unarmed_idle"
			anim_set["travel"] = "unarmed_run"
			anim_set["crouch"] = "crouch"
			anim_set["die"] = "die1"
		armed_types.ARMED:
			anim_set["idle"] = "unarmed_idle"
			anim_set["travel"] = "unarmed_run"
			anim_set["crouch"] = "crouch"
			anim_set["die"] = "die1"
#		armed_types.AKIMBO:
#			anim_set["idle"] = "akimbo_idle"
#			anim_set["run"] = "akimbo_run"
#			anim_set["jump"] = "akimbo_jump"
#			anim_set["crouch"] = "crouch"
#			anim_set["handstand"] = "armed_handstand"
	armed_type = new_armed_type
	return

func hit(damage: int, hit_type: int):
	if is_dead: return
	grunt_brain.wake_up()
	grunt_brain.is_aggressive = true
	grunt_brain.look_at_offline_player()
	grunt_brain.aim_and_shoot()
	
	health -= damage
	if hit_type == U.hit_types.UNDEFINED:
		hit_sound.play()
	elif hit_type == U.hit_types.KICK:
		$Sound/hit_sound2.play()
	elif hit_type == U.hit_types.KNOCKABLE:
		$Sound/knockable_hit.play()
	
	if health > 0:
		anim_h("flinch", true, .3)
#		if hit_type == U.hit_types.UNDEFINED:
#			hit_sound.play()
#		elif hit_type == U.hit_types.KICK:
#			$Sound/hit_sound2.play()
#		elif hit_type == U.hit_types.KNOCKABLE:
#			$Sound/knockable_hit.play()
		
		var rand_choice: int = randi_range(0, 3)
		match rand_choice:
			0:
				$Sound/hurt_sound1.play()
			1:
				pass
			2:
				$Sound/hurt_sound3.play()

	return

func anim_h(anim_name: String = "", force_anim: bool = false, duration: float = 0.0):
	if anim_name == "":
		return
	
	if anim_locked and not force_anim:
		return
	
	if force_anim:
		anim.seek(0)
		anim.stop()
	
	if force_anim and duration > 0:
		anim_timer.wait_time = duration
		anim_locked = true
		anim_timer.start()

	elif force_anim and duration == 0:
		anim_timer.wait_time = 1
		anim_locked = true
		anim_timer.start()
	
	anim.play(anim_name)
	last_anim = anim_name
	return


func _on_anim_timer_timeout():
	anim_locked = false
	return

func kill_actor():
	is_dead = true
	grunt_brain.process_mode = Node.PROCESS_MODE_DISABLED
#	for child in self.get_children():
#		if child.name.begins_with("hitbox_"):
#			child.disabled = true
	if randi_range(0, 1) == 0:
		$Sound/die_sound.play()
	else:
		$Sound/die_sound2.play()
	
	self.position.y += 1
	var dead_collider: CollisionShape3D = preload("res://Scenes/dead_collider.tscn").instantiate()
	self.add_child(dead_collider)
	$hitbox_head_col.disabled = true
	$hitbox_lower.disabled = true
	$hitbox_torso_col.disabled = true
	return
