extends Node3D

var hud_name: String = "BugSMG"
@onready var raycast: RayCast3D = $RayCast3D
@onready var anim: AnimationPlayer = $AnimationPlayer
@onready var aim_dot: MeshInstance3D = $aim_dot
@onready var smoke_puff: Sprite3D = $"Lazy Cache/smoke_puff"
var smoke_puff_fpath: String = ""
var default_shoot_sound_pitch: float = 1.5
var default_aim_dot_color: Color = Color(0.4863, 0.4863, 0.4863, 1)

var damage: int = 12

var primary_action_type: int = U.primary_action_types.HOLD
# Called when the node enters the scene tree for the first time.
func _ready():
	return


func _process(delta):
	aim_dot_control()
	return

func primary_action(caller, action_type):
	full_auto_shoot(caller)
	return

func aim_dot_control():
	if raycast.is_colliding():
		var collision_point: Vector3 = raycast.get_collision_point()
		var aim_distance: float = self.global_position.distance_to(collision_point)
		if aim_distance < 2.0:
			aim_dot.visible = false
		else:
			aim_dot.visible = true
		
		var aim_dot_material: Material = aim_dot.get_active_material(0)
		var collider: Object = raycast.get_collider()
		if raycast.get_collider().is_in_group("actors"):
			aim_dot_material.albedo_color = Color(1, 0, 0, 0.5216)
		else:
			aim_dot_material.albedo_color = default_aim_dot_color
		aim_dot.global_position = collision_point
	else:
		aim_dot.visible = false
	return

func impact_control():
	var collider: Object = raycast.get_collider()
	if collider:
		print(collider.name)
		if collider.is_in_group("hit_takers"):
			collider.hit(damage)
		
		var impact_position = raycast.get_collision_point()
		var new_smoke_puff: Sprite3D = smoke_puff.duplicate()
		var assumed_world = get_tree().get_first_node_in_group("Worlds")
		assumed_world.add_child(new_smoke_puff)
		new_smoke_puff.global_position = raycast.get_collision_point()
		new_smoke_puff.get_node("AnimationPlayer").play("fade")
	return

func semi_auto_shoot(caller):
	anim.stop()
	anim.play("shoot semi")
	impact_control()
	return

func full_auto_shoot(caller):
	randomize_shoot_pitch()
	anim.play("shoot auto")
	#impact_control()
	return

func stop_action(caller, action_type):
	anim.stop()
	anim.play("idle")
	if action_type == U.primary_action_types.HOLD:
		$semi_shoot.pitch_scale = default_shoot_sound_pitch
	return

func randomize_shoot_pitch():
	var new_pitch: float = 0.0
	var first_step: int = randi_range(0, 2)
	if first_step == 0:
		new_pitch = randf_range(1.3, 1.5)
	elif first_step == 1:
		new_pitch = randf_range(1.5, 1.7)
	elif first_step == 2:
		new_pitch = 2.0
	$semi_shoot.pitch_scale = new_pitch

	return

func reload(caller):
	$reload.play()
	return


func _on_delayed_ticker_timeout():
	return
