extends Node3D

var actor: CharacterBody3D
@onready var raycast: RayCast3D = $RayCast3D
var damage: int = 12
var knockback_force: float = 0.10

func shoot():
	if not actor:
		get_tree().get_first_node_in_group("players")
	$shoot_sound.pitch_scale = randf_range(.9, 1.1)
	$muzzle_flare.visible = true
	$muzzle_flare_light.visible = true
	$shoot_sound.play()
	A.create_impact(actor, raycast, damage, knockback_force)
	await get_tree().create_timer(.1).timeout
	$muzzle_flare.visible = false
	$muzzle_flare_light.visible = false
	return

func shoot_empty():
	$shoot_click.play()
	return
