extends Control

signal scene_ended
var is_sequence_over: bool = false

# Called when the node enters the scene tree for the first time.
func _ready():
	var show_time: float = 12.0
	await get_tree().create_timer(show_time).timeout
	if not is_sequence_over:
		is_sequence_over = true
		fade_out()
	return

func _unhandled_input(event):
	if not is_sequence_over:
		is_sequence_over = true
		fade_out()
	return

func fade_out():
	$ColorRect/AnimationPlayer.play("fade_out")
	var fade_time: float = 0.8
	get_tree().create_tween().tween_property(
		$Node3D/AudioStreamPlayer3D,
		"volume_db",
		-200,
		fade_time
	)
	await get_tree().create_timer(
		$ColorRect/AnimationPlayer.get_animation("fade_out").length
	).timeout
	self.scene_ended.emit()
	return
