extends Node3D

@export var is_dropping: bool = true
@export var dropping_speed: float = 0.05
var recent_position: Vector3 = Vector3.ZERO
var tick: float = 0.0
var tick_interval: float = 0.065
var remote_spatial: Node3D = null

func _ready():
	return

func _physics_process(delta):
	tick += delta
	if tick > tick_interval:
		tick = 0.0
		tick_control()
	if is_dropping:
		self.global_position.y -= dropping_speed
		if remote_spatial:
			#remote_spatial.global_position = recent_position if recent_position else self.global_position
			remote_spatial.global_position = self.global_position
	
	collision_check()
	return

func collision_check():
	var colliders: Array = $Area3D.get_overlapping_bodies()
	if not colliders: return
	
	for collider in colliders:
		#if is_instance_of(collider, StaticBody3D):
		#	continue
		if collider == remote_spatial:
			continue
		if collider.get_parent() == remote_spatial:
			continue
		if collider.name.contains("geometry_col"):
			is_dropping = false
			finished_dropping()
			break
	return

func tick_control():
	recent_position = self.global_position
	return

func finished_dropping():
	remote_spatial.global_position = recent_position if recent_position else self.global_position
	self.queue_free()
	return
