extends Node3D

@export var is_dangerous: bool = true
@export var is_spinning: bool = true
var damage: int = 12
var damage_distance: float = 9.0

@onready var projectile_anchor: Node3D = $projectile_anchor
var is_flying: bool = true
@export var flying_speed: float = 1.0 # .08 # lolspeed = 0.08
@export var rotation_speed: float = 5.0
var init_finished: bool = false
var projectile_initiator: Node3D
var projectile_rotation: Vector3
var direction_origin: Vector3 = Vector3.ZERO
var direction_destination: Vector3 = Vector3.ZERO
var projectile_props: Dictionary = {}
var kill_callback: Callable = func(): return # Need position at the moment of impact. Don't know a simple way to do this with a previously set callback.
var recent_kill_position: Vector3
var tick: float = 0.0
var tick_interval: float = 0.08 # loltick_interval = .4

func _exit_tree():
	prints(self.name, "exited tree")
	return

func _ready():
	await get_tree().process_frame
	init_finished = true
	return

func _physics_process(delta):
	tick += delta
	if tick > tick_interval:
		tick = 0.0
		tick_control()
	#$projectile_anchor/Label3D.text = str(snappedf(tick, 0.01))
	
	if is_flying and init_finished:
		if not projectile_rotation:
			if projectile_initiator.is_in_group("players"):
				projectile_rotation = projectile_initiator.get_node("cam_base").global_rotation
			else:
				projectile_rotation = projectile_initiator.global_rotation
			
			self.global_rotation = projectile_rotation
		
		projectile_anchor.position.z -= flying_speed
		if is_spinning:
			projectile_anchor.rotation_degrees.x += rotation_speed
		collision_check()
	return

func collision_check():
	var colliders: Array = projectile_anchor.get_node("Area3D").get_overlapping_bodies()
	if not colliders: return
	
	for collider in colliders:
		if collider == projectile_initiator:
			continue
		kill_projectile()
	return

func kill_projectile():
	self.visible = false
	self.queue_free()
	var kill_position = projectile_anchor.global_position
	var item_type: String = str(projectile_props.get("item"))
	if item_type == "bottleitem":
		var spawn_position: Vector3 = recent_kill_position if recent_kill_position else kill_position
		U.spawn_bottle_break(spawn_position, projectile_props)
	#kill_callback.call()
	
	if is_dangerous:
		var nodes_damaged: int = 0
		for hit_taker in get_tree().get_nodes_in_group("hit_takers"):
			if hit_taker.global_position.distance_to(kill_position) > damage_distance:
				continue
			if nodes_damaged > 0 and hit_taker.is_in_group("breakables"):
				continue
			#hit_taker.hit(damage, U.hit_types.UNDEFINED, self, kill_position)
			hit_taker.hit(damage, U.hit_types.UNDEFINED, null, kill_position)
			nodes_damaged += 1
			#func hit(damage: int, hit_type: int, caller: CharacterBody3D, hit_pos: Vector3):
	return

func set_projectile(projectile_node: Node3D):
	projectile_anchor.add_child(projectile_node.duplicate())
	projectile_node.queue_free()
	return

func tick_control():
	recent_kill_position = projectile_anchor.global_position
	#U.spawn_green_marker(Blackboard.current_world, recent_kill_position, .5)
	return
