@tool
extends Node
var actor: CharacterBody3D

#@export var gasmask: bool = false :
	#set(value):
		#gasmask = value
		#if not actor:
			#actor = self.get_parent()
		#
		#if not actor: # Still
			#return
		#
		#actor.find_child("grunt_gasmask").visible = value
		#actor.find_child("grunt_chinstrap").visible = !value
		#return

enum variants {
	NONE,
	MALE_BOXY
}
@export var variant: variants = variants.MALE_BOXY :
	set(value):
		variant = value
		match value:
			variants.MALE_BOXY:
				var boxy_mesh_matches: Array = [
					"glasses_1",
					"head_boxy_1",
					"pants_boxy_1",
					"shoes_boxy_1",
					"arms_boxy_1",
					"shirt_boxy_formal_1",
					"head_boxy_hair_1",
					"neck_boxy_1"
				]
				for mesh in actor.get_node("civilian_male").find_child("Skeleton3D").find_children("*", "MeshInstance3D"):
					mesh.visible = false
					for meshmatch in boxy_mesh_matches:
						if mesh.name.contains(meshmatch):
							mesh.visible = true
		return
	get:
		return variant

func _enter_tree() -> void:
	if not actor:
		actor = self.get_parent()
	return

func _ready() -> void:
	return

