@tool
extends Node
var actor: CharacterBody3D

enum outfit_opts {
	HECU_OPEN,
	HECU_CLOSED,
	HALF_CLOWN
}
@export var outfit: outfit_opts = outfit_opts.HECU_OPEN :
	set(value):
		outfit = value
		if not Engine.is_editor_hint():
			return
		if not actor:
			actor = self.get_parent()
		var skelly: Skeleton3D = actor.find_children("*", "Skeleton3D")[0]
		var all_meshes: Array = skelly.find_children("*", "MeshInstance3D")
		for mesh in all_meshes:
			mesh.visible = false
		#var base_clown_meshnames: Array = [
			#"civ_body_female_neck",
			#"civ_body_female_pelvis",
			#"civ_body_female_stomach",
			#"clown_f_arms",
			#"clown_f_collar",
			#"clown_f_costume_1",
			#"clown_f_costume_1_under",
			#"clown_f_hair_1",
			#"clown_f_hair_2",
			#"clown_f_hair_3",
			#"clown_f_head_1",
			#"clown_f_legs",
			#"clown_f_shoes_1",
			#"clown_f_shoes_2",
			#"clown_f_torso_1",
			#"grunt_clothes",
			#"grunt_clothes_open",
			#"grunt_clothes_open_001",
			#"mook_biker_helmet",
			#"stolen_grunt_gasmask",
			#"vest",
			#"vest_bigger"
		#]
		match value:
			outfit_opts.HECU_OPEN:
				$"../model/Armature/Skeleton3D/civ_body_female_neck".visible = true
				$"../model/Armature/Skeleton3D/clown_f_arms".visible = true
				$"../model/Armature/Skeleton3D/clown_f_collar".visible = true
				$"../model/Armature/Skeleton3D/clown_f_costume_1_under".visible = true
				$"../model/Armature/Skeleton3D/clown_f_shoes_2".visible = true
				$"../model/Armature/Skeleton3D/grunt_clothes_open".visible = true
				$"../model/Armature/Skeleton3D/stolen_grunt_gasmask".visible = true
				return
			outfit_opts.HECU_CLOSED:
				$"../model/Armature/Skeleton3D/civ_body_female_neck".visible = true
				$"../model/Armature/Skeleton3D/clown_f_arms".visible = true
				$"../model/Armature/Skeleton3D/clown_f_collar".visible = true
				$"../model/Armature/Skeleton3D/clown_f_shoes_2".visible = true
				$"../model/Armature/Skeleton3D/grunt_clothes".visible = true
				$"../model/Armature/Skeleton3D/stolen_grunt_gasmask".visible = true
				return
			outfit_opts.HALF_CLOWN:
				$"../model/Armature/Skeleton3D/civ_body_female_neck".visible = true
				$"../model/Armature/Skeleton3D/clown_f_arms".visible = true
				$"../model/Armature/Skeleton3D/clown_f_collar".visible = true
				$"../model/Armature/Skeleton3D/clown_f_shoes_2".visible = true
				$"../model/Armature/Skeleton3D/stolen_grunt_gasmask".visible = true
				$"../model/Armature/Skeleton3D/clown_f_costume_1".visible = true
				return
		return



func _enter_tree() -> void:
	if not actor:
		actor = self.get_parent()
	return

func _ready() -> void:
	#gasmask = gasmask
	return

func _process(delta: float) -> void:
	#if not Engine.is_editor_hint():
		#return
	#if actor.is_leader and not actor.get_node("editor_label_leader").visible:
		#actor.get_node("editor_label_leader").visible = true
	#elif not actor.is_leader and actor.get_node("editor_label_leader").visible:
		#actor.get_node("editor_label_leader").visible = false
	return
