extends Control

var locked: bool = false

func _ready():
	toggle_lock_icon(false)
	$VBoxContainer/Resume.grab_focus()
	return

func _unhandled_key_input(event):
	if locked: return
	
	if Input.is_action_just_pressed("ui_cancel"):
		var command_bar: Control = get_tree().get_first_node_in_group("ui_command_bar")
		if command_bar and command_bar.is_enabled:
			return
		toggle_escape_menu()
	return

func toggle_lock_icon(state: bool):
	if state == true:
		$lock_icons/lock_locked.visible = true
		$lock_icons/lock_unlocked.visible = false
		return
	elif state == false:
		$lock_icons/lock_locked.visible = false
		$lock_icons/lock_unlocked.visible = true
		return
	return

func toggle_escape_menu():
	self.visible = !self.visible
	if Input.mouse_mode == Input.MOUSE_MODE_CAPTURED:
		Input.mouse_mode = Input.MOUSE_MODE_VISIBLE
	elif Input.mouse_mode == Input.MOUSE_MODE_VISIBLE:
		Input.mouse_mode = Input.MOUSE_MODE_CAPTURED
	
	var player: Node3D = get_tree().get_first_node_in_group("players")
	if self.visible:
		if player: player.is_menu_enabled = true
		$VBoxContainer/Resume.grab_focus()
	elif not self.visible:
		if player: player.is_menu_enabled = false
	return

func _on_resume_pressed():
	toggle_escape_menu()
	return


func _on_settings_pressed():
	$settings_menu.visible = true
	return


func _on_quit_pressed():
	# Some day I might add an extra button so
	# one is quit game and one is exit to main menu
	# or there's a popup after hitting quit that does that
	# but I don't see a big benefit right now
	get_tree().quit()
	return


func _on_main_menu_pressed():
	get_tree().change_scene_to_file("res://Scenes/main_menu.tscn")
	return
