extends StaticBody3D

@onready var exit_camera: Camera3D = $"../../exit_camera"
@onready var victory_pos_noko: Marker3D = $"../../victory_pos_noko"
@onready var victory_pos_sara: Marker3D = $"../../victory_pos_sara"
var assumed_player: CharacterBody3D
var is_interactable: bool = true
var force_camera: bool = false

# Called when the node enters the scene tree for the first time.
func _ready():
	assumed_player = get_tree().get_first_node_in_group("players")
	return


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	if assumed_player:
		exit_camera.look_at(assumed_player.global_position, Vector3.UP)
		if force_camera:
			exit_camera.make_current()
	return

func interact(caller):
	print("Exit triggered")
	if not is_interactable:
		return
	
	var assumed_minion: CharacterBody3D = get_tree().get_first_node_in_group("player_minions")
	
	print(assumed_player.global_position)
	print(victory_pos_noko.global_position)
	
	assumed_minion.is_dancing = true
	assumed_minion.anim.speed_scale = 4.0
	assumed_minion.anim.play("gesture_carlton_dance")
	assumed_player.global_position = victory_pos_noko.global_position
	assumed_minion.global_position = victory_pos_sara.global_position
	is_interactable = false
	force_camera = true
	exit_camera.make_current()
	Engine.time_scale = .05
	$intermission.play()
	
	var kill_count: String = str(len(assumed_player.actors_killed) + len(assumed_minion.actors_killed))
	var kills_possible: String = str(
		$"../../../../wiseguy_container".get_child_count()
	)
	
	var secrets_possible_raw: int = 1
	var secret_nodes_remaining: int = len(get_tree().get_nodes_in_group("secrets"))
	var secret_count: String = str(
		secrets_possible_raw - secret_nodes_remaining
	)
	var secrets_possible: String = str(secrets_possible_raw)
	$"../../exit_cube_control/kills".text = "KILLS: " + kill_count + " / " + kills_possible
	$"../../exit_cube_control/secrets".text = "SECRETS: " + secret_count + " / " + secrets_possible
	$"../../exit_cube_control/time".text = "TIME: " + str(
		snappedf(assumed_player.delta_count, 0.1)
	)
	
	
	$"../../exit_cube_control/kills".visible = true
	$"../../exit_cube_control/secrets".visible = true
	$"../../exit_cube_control/time".visible = true
	
	return
