extends RigidBody3D

var thrower: Node3D
var knife_damage: int = 25
var is_dangerous: bool = true
@onready var anim: AnimationPlayer = $anchor/butcher_knife/AnimationPlayer
@onready var knife: Node3D = $anchor/butcher_knife
# Called when the node enters the scene tree for the first time.
func _ready():
	$spinning_sound.pitch_scale = randf_range(1.0, 1.05)
	return


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	return


func _on_body_entered(body):
#	anim.play("static")
#	self.freeze = true

	if body.is_in_group("projectiles"):
		is_dangerous = false
		body.deflected()
		if is_instance_of(body, RigidBody3D):
			body.add_collision_exception_with(self)
			body.linear_velocity *= -1
			body.linear_velocity *= 0.33
		return
	
	anim.play("static")
	self.freeze = true
	
	if not is_dangerous:
		return
	if is_instance_of(body, CharacterBody3D):
		$meat_hit.play()
		try_knife_hit(body)
	else:
		$wall_hit.play()
	return

func try_knife_hit(body: CharacterBody3D):
	if not body.is_in_group("hit_takers"):
		return
	
	var hit_caller: CharacterBody3D = null
	if is_instance_of(thrower, CharacterBody3D):
		hit_caller = thrower
	
	body.hit(knife_damage, U.hit_types.UNDEFINED, hit_caller, self.global_position)
	#anim.play("static")
	#self.freeze = true
	knife.get_parent().remove_child(knife)
	body.add_child(knife)
	knife.position.y += 1.5
	await get_tree().create_timer(0.8).timeout
	knife.queue_free()
	self.queue_free()
	return

func deflected():
	$deflected_sound.play()
	return

func _on_die_timer_timeout():
	queue_free()
	return


func _on_sound_timer_timeout():
	$spinning_sound.stop()
	return
