extends RigidBody3D


#@onready var lame_glass_shard: MeshInstance3D = $lame_glass_shard
@onready var lame_glass_shards: Array = self.find_children("lame_glass_shard_*")
@onready var full_cell: MeshInstance3D = $full_cell
@onready var splash_area: Area3D = $splash_area
@onready var glass_sounds: Array = self.find_children("glass_sound_*")
@onready var debug_lights: Array = self.find_children("debug_light*")
var active_gravity_scale: float = 1.0
var velo_threshold_sq: float = 5.0 # 50.0 # 50.0 worked great except on the mp5t_9mm, I suspect the force was too low to register.
var latest_physics_state: PhysicsDirectBodyState3D
var modified_velocity: Vector3 = Vector3.ZERO
@export var spawn_and_freeze: bool = true
var is_spawned: bool = false
var is_separated: bool = false
var is_in_grid: bool = false
var travel_dist_sq: float = 0.0
var separated_dist_sq: float = 0.50 # 1.0
var milkyway_dist_sq: float = 1500.0
var original_origin: Vector3 = Vector3.ZERO
var is_ever_active: bool = false
var is_area_activated: bool = false
var is_performing_float_check: bool = false
var area_cooloff: float = 1.50
var area_ticker: float = 0.0
var recent_nearby_cells: Array = []
var available_rotations: Array = [0.0, 90.0, -90.0, 180.0]
var cells_absorbed: int = 0
var cell_absorb_limit: int = 1
var cell_height: float = 1.0


func _ready() -> void:
	original_origin = self.global_position
	for lame_glass_shard in lame_glass_shards:
		if (U.coin_flip() and U.coin_flip()):
			lame_glass_shard.rotation_degrees.z = randf_range(0.0, 180.0)
		else:
			var new_rotation: float = available_rotations.pick_random()
			lame_glass_shard.rotation_degrees.z = new_rotation
			available_rotations.erase(new_rotation)
		lame_glass_shard.mesh.left_to_right = [0.0, 0.5, 1.0].pick_random()
	if spawn_and_freeze:
		freeze = true
		await get_tree().create_timer(1.0).timeout
		freeze = false
	
	
	is_spawned = true
	if U.coin_flip():
		full_cell.visible = false
	return

func _physics_process(delta: float) -> void:
	travel_dist_sq = self.global_position.distance_squared_to(original_origin)
	
	if $debug_label.visible:
		#$debug_label.text = str(travel_dist_sq)
		$debug_label.text = self.name
	
	if area_ticker > 0.0:
		for b in splash_area.get_overlapping_bodies():
			if not recent_nearby_cells.has(b):
				recent_nearby_cells.append(b)
			if b.is_in_group("glass_cells"):
				if (U.coin_flip() and U.coin_flip()):
					b.set_as_separated()
					continue
				if U.coin_flip():
					#b.full_cell.visible = false
					full_cell.transparency *= 4.6
					continue
		area_ticker -= delta
		if area_ticker <= 0.0:
			area_ticker = 0.0
			splash_area.monitoring = false
			if recent_nearby_cells.size() == 0:
				is_separated = true
	
	if travel_dist_sq > milkyway_dist_sq:
		self.queue_free()
		return
	
	if not is_separated and travel_dist_sq >= separated_dist_sq:
		set_as_separated()
		return
	
	return

func _on_sleeping_state_changed() -> void:
	if is_separated:
		return
	
	if linear_velocity.length_squared() > velo_threshold_sq: # and (U.coin_flip() and U.coin_flip()):
		gravity_scale = active_gravity_scale
		splash_area.monitoring = true
		area_ticker = area_cooloff
		if is_in_grid:
			self.get_parent().get_parent()._cell_impacted(self)
		var glass_sound: AudioStreamPlayer3D = glass_sounds.pick_random()
		glass_sound.pitch_scale = randf_range(.95, 1.05)
		glass_sound.play()
		tilt_area()
		#full_cell.visible = false
	else:
		await get_tree().create_timer(.02).timeout
		if not is_separated:
			sleeping = true
	
	if rotation_degrees.length_squared() > 1.0:
		#full_cell.visible = false
		full_cell.transparency *= 4.6
	return














#func _physics_process(delta: float) -> void:
	#if $debug_label.visible:
		##if sleeping:
			##$debug_label.text = "s"
		##else:
			##$debug_label.text = "A"
		#$debug_label.text = str(
			#snappedf(travel_dist_sq, 0.01)
		#)
	#
	#if is_ever_active:
		#travel_dist_sq = self.global_position.distance_squared_to(original_origin)
	#return
#
#func _integrate_forces(state: PhysicsDirectBodyState3D) -> void:
	#if not is_spawned:
		#return
	#
	#latest_physics_state = state
	#if modified_velocity:
		#state.linear_velocity = modified_velocity
	#return
#
#func _on_sleeping_state_changed() -> void:
	#if not is_spawned:
		#return
	#if not latest_physics_state:
		#return
	#if linear_velocity.is_zero_approx():
		#return
	#
	#prints(self.name, "Sleeping state changed!")
	#prints(self.name, linear_velocity.length_squared())
	#blink_debug_lights()
	#
	#gravity_scale = active_gravity_scale
	#is_ever_active = true
	#
	#if linear_velocity.length_squared() > squared_break_threshold:
		##is_ever_active = true
		#splash_area.monitoring = true
		#for b in splash_area.get_overlapping_bodies():
			#if b.is_in_group("glass_cells"):
				#b.apply_force(Vector3(0.0, 1.0, 0.0))
	#else:
		#modified_velocity = latest_physics_state.linear_velocity
		#var sludge_time: float = .2 # .2
		##get_tree().create_tween().tween_property(self, "modified_velocity", Vector3.ZERO, sludge_time)
		#get_tree().create_tween().tween_property(self, "linear_velocity", Vector3.ZERO, sludge_time)
		##get_tree().create_tween().tween_property(self, "gravity_scale", 0.0, sludge_time)
		#get_tree().create_timer(sludge_time + 0.01).timeout
		#modified_velocity = Vector3.ZERO
		#sleeping = true
		#
		#if travel_dist_sq < separated_dist_sq:
			#get_tree().create_tween().tween_property(self, "gravity_scale", 0.0, sludge_time)
	#return
#

#
#


func _on_float_check_timer_timeout() -> void:
	if is_separated:
		return
	
	if is_performing_float_check:
		return
	
	is_performing_float_check = true
	splash_area.monitoring = true
	await get_tree().create_timer(.1).timeout
	
	var bodies: Array = splash_area.get_overlapping_bodies()
	bodies.erase(self)
	if self.name == "glass_cell_6":
		pass
	if bodies.size() == 0:
		set_as_separated()
	
	#if bodies.size() > 0 and travel_dist_sq > 0.1:
		#var absorb_candidate: PhysicsBody3D = bodies.pick_random()
		#if absorb_candidate.is_in_group("glass_cells"):
			#absorb_cell(absorb_candidate)
	
	is_performing_float_check = false
	return

func set_as_separated() -> void:
	if is_separated:
		return
	
	is_separated = true
	full_cell.visible = false
	sleeping = false
	gravity_scale = active_gravity_scale
	apply_torque_impulse(Vector3.ONE * .01)
	lame_glass_shards.pick_random().visible = false
	
	for actor in get_tree().get_nodes_in_group("actors"):
		self.add_collision_exception_with(actor)
	
	### Happens to cells that are still "on grid"
	sleeping = false
	freeze = false
	gravity_scale = active_gravity_scale * 4
	await get_tree().create_timer(5.2).timeout
	#freeze = true
	#await get_tree().create_timer(1.0).timeout
	process_mode = Node.PROCESS_MODE_DISABLED
	return

func absorb_cell(cell_node: RigidBody3D) -> void:
	#if cell_node.is_separated:
		#return
	if not cell_node:
		return
	
	if cells_absorbed >= cell_absorb_limit:
		return
	
	var new_children: Array = []
	new_children.append(cell_node.get_node("CollisionShape3D"))
	new_children.append_array(cell_node.lame_glass_shards)
	for new_child in new_children:
		new_child.reparent(self)
	
	cells_absorbed += 1
	cell_node.queue_free()
	return

func blink_debug_lights(blink_color: Color = Color.GREEN) -> void:
	#for debug_light in debug_lights:
		#debug_light.visible = true
	debug_lights.map(func (node): node.visible = true)
	await get_tree().create_timer(.1).timeout
	debug_lights.map(func (node): node.visible = false)
	await get_tree().create_timer(.1).timeout
	debug_lights.map(func (node): node.visible = true)
	await get_tree().create_timer(.1).timeout
	debug_lights.map(func (node): node.visible = false)
	return

func tilt_area() -> void:
	splash_area.rotation_degrees.z += randf_range(-90, 90)
	var colliders: Array = [$CollisionShape3D, $splash_area/asym_collider]
	var collider_i: int = [0, 1].pick_random()
	if collider_i == 0:
		colliders[0].disabled = false
		colliders[1].disabled = true
	elif collider_i == 1:
		colliders[0].disabled = true
		colliders[1].disabled = false
	
	return

func blowout() -> void:
	var colliders: Array = splash_area.find_children("*", "CollisionShape3D")
	var collider_states: Dictionary = {}
	for collider in colliders:
		collider_states[collider] = collider.disabled
		if collider.name.contains("blowout"):
			collider.disabled = false
		else:
			collider.disabled = true
	
	await get_tree().process_frame
	
	for b in splash_area.get_overlapping_bodies():
		if not b.is_in_group("glass_cells"):
			continue
		if b == self:
			continue
		var cell_dist_sq: float = b.global_position.distance_squared_to(self.global_position)
		var blowout_force: float = 88.2 * cell_dist_sq
		var blowout_vec: Vector3 = b.global_position - self.global_position
		b.apply_central_impulse(blowout_vec * blowout_force)
		b.apply_torque_impulse(Vector3.ONE * blowout_force)
	
	for collider in colliders:
		collider.disabled = collider_states[collider]
	return
