extends Node3D

@onready var raycast: RayCast3D = $RayCast3D
@onready var anim: AnimationPlayer = $AnimationPlayer

@onready var smoke_puff: Sprite3D = $"Lazy Cache/smoke_puff"
#var smoke_puff_fpath: String = ""
var default_shoot_sound_pitch: float = 1.5


var damage: int = 45

func _ready():
	return


func _process(delta):
	return

func primary_action(caller, action_type):
	match action_type:
		U.primary_action_types.TAP:
			semi_auto_shoot(caller)
		U.primary_action_types.HOLD:
			full_auto_shoot(caller)
	return


func impact_control():
	var collider: Object = raycast.get_collider()
	if collider:
		if collider.is_in_group("hit_takers"):
			collider.hit(damage)
		
		var impact_position = raycast.get_collision_point()
		var new_smoke_puff: Sprite3D = smoke_puff.duplicate()
		var assumed_world = get_tree().get_first_node_in_group("Worlds")
		assumed_world.child(new_smoke_puff)
		new_smoke_puff.global_position = raycast.get_collision_point()
		new_smoke_puff.get_node("AnimationPlayer").play("fade")
	return

func semi_auto_shoot(caller):
	anim.stop()
	anim.play("shoot semi")
	impact_control()
	return

func full_auto_shoot(caller):
	randomize_shoot_pitch()
	var collider: Object = raycast.get_collider()
	if collider and collider.is_in_group("heavy_grunts"): return
	anim.play("shoot auto")
	#impact_control()
	return

func stop_action(caller, action_type):
	anim.stop()
	anim.play("idle")
	if action_type == U.primary_action_types.HOLD:
		$semi_shoot.pitch_scale = default_shoot_sound_pitch
	return

func randomize_shoot_pitch():
	var new_pitch: float = 0.0
	var first_step: int = randi_range(0, 2)
	if first_step == 0:
		new_pitch = randf_range(.7, .8)
	elif first_step == 1:
		new_pitch = randf_range(.8, .9)
	elif first_step == 2:
		new_pitch = .6
	$semi_shoot.pitch_scale = new_pitch

	return

func reload(caller):
	$reload.play()
	return


func _on_delayed_ticker_timeout():
	return
