extends AnimatableBody3D


# Buy a ticket from this person with credits

# If you're holding a gun you'll be asked to put it away before
# purchasing anything

# 
@onready var eyes: Node3D = $mid_anchor/eyes
@onready var anim: AnimationPlayer = $jp_civ_female/AnimationPlayer
var player_range_threshold: float = 19.0
var player_engage_threshold: float = 15.0
var tick_interval: float = 1.0
var tick: float = 0
var original_rotation: Vector3 = Vector3.ZERO

var is_gesture_allowed: bool = true
var last_caller: Node3D
@export var ticket_name: String = "hdmi_ticket"

func _ready():
	original_rotation = self.global_rotation
	anim.play("jp_f_idle_2")
	return

func _physics_process(delta):
	tick += delta
	if tick >= tick_interval:
		tick_control()
		tick = 0
	return

func tick_control():
	var player: CharacterBody3D = get_tree().get_first_node_in_group("players")
	if A.distance(self, player) < player_range_threshold:
		A.face_position(self, player.global_position)
		if player.armed_type != U.armed_types.UNARMED and is_gesture_allowed:
			is_gesture_allowed = false
			anim.play("jp_f_gesture_no_1")
			anim.queue("jp_f_idle_2")
			await get_tree().create_timer(1.2).timeout
			is_gesture_allowed = true
	else:
		self.global_rotation = original_rotation
	
	return

func interact(caller: Node3D):
	if not caller.is_in_group("players"):
		prints(self.name, "Called from non-player, abort.")
		return
	
	last_caller = caller
	caller.ui_prompt({
		"responses": ["Yes", "No"],
		"prompt": "Buy ticket?",
		"caller": self,
		"callback": "_give_venue_ticket"
	})
	return

#func _give_venue_ticket(ticket_recipient: Node3D):
func _give_venue_ticket(prompt_response: String):
	if prompt_response == "No":
		return
	elif prompt_response == "Yes":
		last_caller.add_doorkey(ticket_name)
		last_caller = null
	else:
		return
	return
