extends Node3D

var actor: CharacterBody3D
@export var damage: int = 28
var knockback_force: float = 50.0
var is_hurting: bool = false

enum kick_types {
	FRONT,
	BACK,
	CROUCHED
}

func primary_action(caller, action_type):
	match action_type:
		U.primary_action_types.TAP:
			hurt_area([caller], kick_types.FRONT)
#		U.primary_action_types.HOLD:
#			hurt_area([caller])
	return

func crouch_kick(caller):
	hurt_area([caller], kick_types.CROUCHED)
	return

func back_kick(caller, action_type):
	$AnimationPlayer.play("back_arch")
	var wait_frames: int = 10
	for frame in wait_frames:
		await get_tree().physics_frame
	await get_tree().process_frame
	match action_type:
		U.primary_action_types.TAP:
			hurt_area([caller], kick_types.BACK)
	await get_tree().create_timer(.5).timeout
	$AnimationPlayer.play("idle")
	return

func stop_action(caller, action_type):
	return

func reload(caller):
	print("I am a kick, nothing to reload.")
	return

func hurt_area(nodes_to_exclude: Array[Object], kick_type: int):
	var assumed_caller: CharacterBody3D = nodes_to_exclude[0]
	for body in $Area3D.get_overlapping_bodies():
		#if body.is_in_group("kickable_doors"):
			#body.interact(self.actor)
		
		if body.is_in_group("hit_takers"):
			var kick_damage: int
			match kick_type:
				kick_types.FRONT:
					kick_damage = damage
				kick_types.BACK:
					kick_damage = (damage * 2)
				kick_types.CROUCHED:
					kick_damage = damage
			var hit_taker: Object = body
			if hit_taker in nodes_to_exclude:
				continue
			hit_taker.hit(kick_damage, U.hit_types.KICK, actor, Vector3.ZERO)
			if is_instance_of(hit_taker, CharacterBody3D) and "health" in hit_taker and hit_taker.health < 1:
				actor._hit_taker_died(hit_taker)
			$kicked_sound.play()
			if is_instance_of(hit_taker, CharacterBody3D) and kick_type == kick_types.CROUCHED:
				hit_taker.velocity.y += (knockback_force * .5)
			if is_instance_of(hit_taker, CharacterBody3D) and kick_type == kick_types.FRONT:
				actor._kick_landed(hit_taker)
			if is_instance_of(hit_taker, CharacterBody3D) and kick_type == kick_types.BACK:
				A.apply_move(hit_taker, Vector2.DOWN, knockback_force * 1.5)
				actor._back_kick_landed(hit_taker)
			
		if is_instance_of(body, RigidBody3D) and not body.is_in_group("droppables"):
			var collider: RigidBody3D = body
			var applied_impulse: Vector3 = (
				Vector3(0, 0.8, 2).rotated(Vector3.UP, self.global_rotation.y) * knockback_force
			)
			if body.is_in_group("glass_cells"):
				applied_impulse *= randf_range(.1, .35)
			if body.is_in_group("actors"):
				applied_impulse *= .2
			
			collider.apply_central_impulse(applied_impulse)
			
		if body.is_in_group("kickables"):
			body.kick(assumed_caller)
		if body.is_in_group("knockables"):
			body.knock(assumed_caller)
		if body.is_in_group("projectiles"):
			body.deflected()
	return
