extends Button

var ui_add: AudioStreamPlayer = AudioStreamPlayer.new()
var ui_remove: AudioStreamPlayer = AudioStreamPlayer.new()
var ui_error: AudioStreamPlayer = AudioStreamPlayer.new()
var ui_index: AudioStreamPlayer = AudioStreamPlayer.new()
var ui_open_long: AudioStreamPlayer = AudioStreamPlayer.new()
var ui_open_short: AudioStreamPlayer = AudioStreamPlayer.new()
var ui_mouse_over_select: AudioStreamPlayer = AudioStreamPlayer.new()
var ui_submit: AudioStreamPlayer = AudioStreamPlayer.new()


var ui_add_wav: AudioStreamWAV = preload("res://Audio/interface/Menu/Add.wav")
var ui_remove_wav: AudioStreamWAV = preload("res://Audio/interface/Menu/ARemove.wav")
var ui_error_wav: AudioStreamWAV = preload("res://Audio/interface/Menu/Error.wav")
var ui_index_wav: AudioStreamWAV = preload("res://Audio/interface/Menu/Index.wav")
var ui_open_long_wav: AudioStreamWAV = preload("res://Audio/interface/Menu/Menu-open-long.wav")
var ui_open_short_wav: AudioStreamWAV = preload("res://Audio/interface/Menu/Menu-open-short.wav")
var ui_mouse_over_select_wav: AudioStreamWAV = preload("res://Audio/interface/Menu/Mouse-over-select.wav")
var ui_submit_wav: AudioStreamWAV = preload("res://Audio/interface/Menu/Submit.wav")


func _ready():
	_init()
	return

func _init():
	ui_add.name = "audio_ui_add"
	ui_remove.name = "audio_ui_remove"
	ui_error.name = "audio_ui_error"
	ui_index.name = "audio_ui_index"
	ui_open_long.name = "audio_ui_open_long"
	ui_open_short.name = "audio_ui_open_short"
	ui_mouse_over_select.name = "audio_ui_mouse_over_select"
	ui_submit.name = "audio_ui_submit"
	
	ui_add.stream = ui_add_wav
	ui_remove.stream = ui_remove_wav
	ui_error.stream = ui_error_wav
	ui_index.stream = ui_index_wav
	ui_open_long.stream = ui_open_long_wav
	ui_open_short.stream = ui_open_short_wav
	ui_mouse_over_select.stream = ui_mouse_over_select_wav
	ui_submit.stream = ui_submit_wav
	
	for sound_node in [ui_add, ui_remove, ui_error, ui_index, ui_open_long, ui_open_short, ui_mouse_over_select, ui_submit]:
		if not sound_node.get_parent():
			self.add_child(sound_node)
	
	
	var base_volume: float = 5.0
	ui_add.volume_db = base_volume
	ui_remove.volume_db = base_volume
	ui_error.volume_db = base_volume
	ui_index.volume_db = base_volume
	ui_open_long.volume_db = base_volume
	ui_open_short.volume_db = base_volume
	ui_mouse_over_select.volume_db = (base_volume * 2.0)
	ui_submit.volume_db = base_volume
	
	if not self.mouse_entered.get_connections():
		self.connect("mouse_entered", _focus_entered)
	
	if not self.focus_entered.get_connections():
		self.connect("focus_entered", _focus_entered)
	
	if not self.pressed.get_connections():
		self.connect("pressed", _button_pressed)
	
	return

func _focus_entered():
	ui_mouse_over_select.play()
	return

func _button_pressed():
	ui_submit.play()
	return
