extends Node3D

var begin_scene_path: String = "res://Scenes/game_tree.tscn"
@export var developer_mode: bool = false
var custom_scene_list: Array = [
	#"res://Scenes/Levels/e2_quiet_please.tscn",
	"res://Scenes/lab_2.tscn", # MAP02
	"res://Scenes/lab_three.tscn", # MAP04
	"res://Scenes/Levels/hanger.tscn", # Hanger```
	"res://Scenes/core_rnd.tscn" # Dark room
]
var dev_scene_selection_list: Array = []

func _enter_tree():
	#AudioServer.set_bus_volume_db(0, 0.0)
	AudioServer.set_bus_volume_db(0, Global.default_master_volume)
	return

func _ready():
	Input.mouse_mode = Input.MOUSE_MODE_VISIBLE
	$UI/main_buttons/ghost_button.grab_focus()
	
	var all_buttons: Array = self.find_children("*", "Button", true)
	var buttons_to_remove: Array
	for button in all_buttons:
		if button.name.contains("ghost"):
			buttons_to_remove.append(button)
			continue
		button.set_script(load("res://Scripts/main_buttons.gd"))
	
	for button in buttons_to_remove:
		all_buttons.erase(button)
	
	await get_tree().process_frame
	for button in all_buttons:
		button._init()
	return

func _physics_process(delta):
	if Input.is_action_just_pressed("ui_down") or Input.is_action_just_pressed("backward"):
		# Focus to top button or next button
		pass
	return

func _on_begin_pressed():
	ui_switch_main_to_enter()
	return

func _on_settings_pressed():
	$UI/settings_menu.visible = true
	return

func _on_quit_pressed():
	get_tree().quit()
	return

func ui_switch_main_to_enter():
	$UI/main_buttons.visible = false
	$UI/enter_buttons.visible = true
	$UI/enter_buttons/enter_new.grab_focus()
	return

func ui_switch_enter_to_main():
	$UI/enter_buttons.visible = false
	$UI/main_buttons.visible = true
	$UI/main_buttons/ghost_button.grab_focus()
	return

func start_loaded_game():
	var fade_time: float = .5
	get_tree().create_tween().tween_property(
		$UI/black_rect,
		"color",
		Color(0, 0, 0, 1),
		fade_time
	)
	get_tree().create_tween().tween_property(
		$Camera3D/AudioStreamPlayer3D,
		"pitch_scale",
		0.41,
		fade_time
	)
	get_tree().create_tween().tween_property(
		$Camera3D/AudioStreamPlayer3D,
		"volume_db",
		-80,
		fade_time
	)
	await get_tree().create_timer(fade_time).timeout
	get_tree().change_scene_to_file("res://Scenes/game_tree.tscn")
	return

func start_new_game():
	# Go to tree
	# Load first level (Noko's dreaming, it's a tutorial!)
#	Director.startup_type = Director.startup_types.NEW
	Director.new_game()
	
	var fade_time: float = .5
	get_tree().create_tween().tween_property(
		$UI/black_rect,
		"color",
		Color(0, 0, 0, 1),
		fade_time
	)
	get_tree().create_tween().tween_property(
		$Camera3D/AudioStreamPlayer3D,
		"pitch_scale",
		0.41,
		fade_time
	)
	get_tree().create_tween().tween_property(
		$Camera3D/AudioStreamPlayer3D,
		"volume_db",
		-80,
		fade_time
	)
	await get_tree().create_timer(fade_time).timeout
	get_tree().change_scene_to_file("res://Scenes/game_tree.tscn")
	return


func _on_enter_back_pressed():
	ui_switch_enter_to_main()
	return


func _on_enter_load_pressed():
	$UI/load_game_box.visible = true
	$UI/enter_buttons.visible = false
	return


func _on_enter_new_pressed():
	Director.scene_index = Director.last_tutorial_index + 1
	start_new_game()
	return


func _on_load_back_pressed():
	$UI/load_game_box.visible = false
	$UI/enter_buttons.visible = true
	return


func _on_dev_button_pressed():
	$UI/dev_buttons.visible = false
	$UI/dev_map_menu.visible = true
	return


func _on_dev_back_pressed():
	$UI/dev_buttons.visible = true
	$UI/dev_map_menu.visible = false
	return


func _on_custom_map_pressed():
	start_scene("res://Scenes/custom_map_loader.tscn")
	return

func start_scene(scene_path: String):
	Director.current_scene_path = scene_path
	
	var fade_time: float = .5
	get_tree().create_tween().tween_property(
		$UI/black_rect,
		"color",
		Color(0, 0, 0, 1),
		fade_time
	)
	get_tree().create_tween().tween_property(
		$Camera3D/AudioStreamPlayer3D,
		"pitch_scale",
		0.41,
		fade_time
	)
	get_tree().create_tween().tween_property(
		$Camera3D/AudioStreamPlayer3D,
		"volume_db",
		-80,
		fade_time
	)
	await get_tree().create_timer(fade_time).timeout
	get_tree().change_scene_to_file("res://Scenes/game_tree.tscn")
	return





func _on_select_map_edit_text_changed(new_text):
	update_scene_select_results(new_text)
	return


func _on_select_map_submit_pressed():
	var selected_scene = $UI/select_map_results.text.split("\n")[1]
	var selected_scene_path: String = ""
	
	prints(self.name, "You have selected scene:", selected_scene)
	#for scene_path in Director.scenes_in_order:
	for scene_path in dev_scene_selection_list:
		if scene_path.contains(selected_scene):
			#Director.current_scene_path = selected_scene
			selected_scene_path = scene_path
			break
	
	# Need to add a situation where there is no valid scene path.
	start_scene(selected_scene_path)
	return


func get_list_of_scenes():
	var scene_list: Array = []
	dev_scene_selection_list.clear()
	for scene_path in Director.scenes_in_order:
		dev_scene_selection_list.append(scene_path)
		var scene_name: String = scene_path.split("/")[-1]
		scene_list.append(scene_name)
	for scene_path in custom_scene_list:
		dev_scene_selection_list.append(scene_path)
		var scene_name: String = scene_path.split("/")[-1]
		scene_list.append(scene_name)
	return scene_list

func update_scene_select_results(query: String):
	var scene_list: Array = get_list_of_scenes()
	$UI/select_map_results.text = ""
	for scene in scene_list:
		if scene.contains(query) or query == "":
			$UI/select_map_results.text += "\n" + scene
	return

func _on_select_map_edit_focus_entered():
	var query: String = $UI/dev_map_menu/select_map_hbox/select_map_edit.text
	update_scene_select_results(query)
	return


func _on_select_map_edit_focus_exited():
	#$UI/select_map_results.text = ""
	return


func _on_enter_tutorial_pressed() -> void:
	start_new_game()
