@tool
extends Node

@export var scroll_speed: float = 0.01
@export var editor_preview: bool = false


func _process(delta):
	if Engine.is_editor_hint() and not editor_preview:
		return
	
	scroll_material()
	return

func scroll_material():
	for child in self.get_parent().get_children():
		if not is_instance_of(child, MeshInstance3D):
			continue
		
		var mesh: MeshInstance3D = child
		for material_index in range(mesh.mesh.get_surface_count()):
			var material: Material = mesh.get_active_material(material_index)
			if material == null:
				continue
			material.uv1_offset.y += scroll_speed
	return


#func set_mesh_materials_alpha(mesh: MeshInstance3D, max_count: int = 10):
#	for i in range(max_count):
#		var current_material: Material = mesh.get_active_material(i)
#		if current_material == null:
#			return
#		current_material.transparency = 1
#		#alpha_mesh.get_active_material(0).transparency = 1
#	return
