extends CharacterBody3D

	# TODO
	# - Give her the ability to jump
	# - Give her the ability to attack without a weapon
	#
	# make animations like "aim_shoot_behind"
	# this will look cool and will reflect how much of a turn
	# the npc had to make to make the shot.
	# So if their next attack rotation is ~180 degrees from their last one
	# shoot behind
	
	#prints(self.name, "velo", self.velocity.abs())
	

signal dropped_weapon

@onready var debug_label: Label3D = $debug_label
@onready var anim: AnimationPlayer = $model/AnimationPlayer
@onready var kevlar: MeshInstance3D = $model/Armature/Skeleton3D/sara_kevlar
@onready var letterman: MeshInstance3D = $model/Armature/Skeleton3D/sara_letterman
@onready var eyes: Node3D = $mid_anchor/eyes
@onready var base_eyes: Node3D = $base_anchor/eyes
@onready var nav_agent: NavigationAgent3D = $NavigationAgent3D
@onready var flinch_timer: Timer = $flinch_timer
@onready var equip_delay: Timer = $equip_delay
@onready var attack_cooloff: Timer = $attack_cooloff
@onready var extended_attack_cooloff: Timer = $extended_attack_cooloff
@onready var stuck_timer: Timer = $stuck_timer
@onready var jump_timer: Timer = $jump_timer
@onready var overkill_timer: Timer = $overkill_timer

@onready var sight_raycast: RayCast3D = $sight_raycast
@onready var strike_raycast: RayCast3D = $strike_raycast
@onready var float_raycast: RayCast3D = $float_raycast
@onready var chest_raycast: RayCast3D = $chest_raycast
@onready var low_raycast: RayCast3D = $low_raycast
@onready var nav_fall_raycast: RayCast3D = $dynamic_base_anchor/nav_fall_raycast
@onready var dynamic_base_anchor: Node3D = $dynamic_base_anchor
@onready var rhand_anchor: Node3D = $model/Armature/Skeleton3D/rhand_attachment/anchor
@onready var ack_sounds: Array = $sounds/follow_sounds.get_children()

@export var health: int = 100
var original_health: int = health
var armor: int = 0
var is_wearing_kevlar: bool = false
@export var melee_damage: int = 16
@export var melee_attack_cooloff: float = 0.2
const JUMP_VELOCITY: float = 26.0 #22.5
const BASE_SPEED: float = 14.0
var move_speed: float = BASE_SPEED
var run_scale: float = 2.0
var max_velo: float = BASE_SPEED * run_scale
var max_air_velo: float = 20.0

var is_dead: bool = false
var is_flinching: bool = false
var is_jumping: bool = false
var is_melee_attacking: bool = false
@export var is_dancing: bool = false
var is_animation_locked: bool = false
var is_door_just_opened: bool = false
var last_anim: String = ""
var queued_anims: Array[String] = []
var anim_set: Dictionary = {
	"idle": "unarmed_idle",
	"run": "unarmed_run",
	"reload": "reload",
	"aim_shoot": "aim_shoot_4",
	"aim_shoot_moving": "aim_shoot_4_moving",
	"after_shoot": "after_shoot_1",
	"flinch": "flinch",
	"die": "die1"
}
var original_anim_set: Dictionary = anim_set.duplicate()
var finisher_anims: Array[String] = ["taunt1", "aim_shoot", "pickup_pistol", "unarmed_idle"]

@export var randomize_attack_time: bool = false
var active_weapon_name: String
var active_weapon_node: Node3D
var active_weapon_ammo_left: int
var active_weapon_mag_size: int
var max_fire_rate: float
var min_fire_rate: float
var is_equipping: bool = false
var is_aiming: bool = false
var is_attacking: bool = false
var is_recently_attacking: bool = false
var is_dropping_weapon: bool = false
var is_vis_turning: bool = false
var is_stuck: bool = false
var is_recently_teleported: bool = false

var latest_moved_positions: Array[Vector3] = []
var latest_nav_reachable_position: Vector3
var recent_global_rotation_degrees: Vector3
var max_latest_moved_positions: int = 3
var stuck_distance_threshold: float = 3.0

var movement_threshold: float = 10.00
var is_moving: bool = false

#############################
enum top_states {
	NONE,
	SCRIPTED_ANIM,
	IDLE,
	FOLLOW_IDLE,
	FOLLOW_MOVE,
	FOLLOW_ATTACK,
	ATTACK,
	MELEE_ATTACK,
	COMMANDED,
	DEAD
}
var top_state: int = top_states.IDLE
var previous_top_state: int = top_state

const BASE_TARGET_DISTANCE_THRESHOLD: float = 50.0
var target_distance_threshold: float = BASE_TARGET_DISTANCE_THRESHOLD
var melee_distance_threshold: float = 7.0
var passive_target: PhysicsBody3D
var active_target: PhysicsBody3D
var melee_target: PhysicsBody3D
var strike_position: Vector3
var target_pool: Array[PhysicsBody3D] = []
@export var groups_i_dont_like: Array[String] = [
	"wiseguys",
	"punks",
	"cultists",
	"mooks",
	"burglars",
	"doormen"
]

var sounds_heard: Array = []
var actors_killed: Array[PhysicsBody3D] = []

@export var boss_actor: CharacterBody3D
var minion_command_point: Vector3
var boss_target: PhysicsBody3D
var interaction_target: Node
var follow_distance: float = 13.0
var far_follow_distance: float = follow_distance * 2.0

#############################

var behavior_process_ticker: float = 0.0
@export var behavior_process_interval: float = 0.04
var volatile_data_ticker: float = 0.0
@export var volatile_data_ticker_interval: float = 1.0

var is_watching_boss: bool = false
var tween_estimate_threshold: float = 1.0
var tween_cleanup_pool: Array = []

var is_never_interacted: bool = true
var recent_hits_tracked: Array = []
var is_hit_a_lot: bool = false

var recent_nav_positions: Array = []
var recent_nav_diff: float = 0.0

func _ready():
	#get_tree().get_first_node_in_group("players").comms_actor_choice = self
	
	#if boss_actor and is_never_interacted:
		#await get_tree().create_timer(3.01).timeout
		#self.interact(boss_actor)
	
	# Load external anims
	for external_animation in [
		{
			"name": "pump_shotgun",
			"path": "res://Staging/Models/Animations/armedlong_pump_3.anim"
		}
	]:
		anim.get_animation_library("").add_animation(
			external_animation["name"],
			load(external_animation["path"])
		)
	
	kevlar.visible = false
	letterman.visible = true
	return

func _physics_process(delta):
	debug_label.text = top_states.keys()[top_state]
	#$debug_label2.text = str(
	#	health
	#)
	
	if not is_dead:
		tick_control(delta)
		
	
	if not is_on_floor():
		A.apply_gravity(self, delta)
	
	animation_control() # Consider moving this to on_behavior_process_tick
	sound_control()
	
	self.velocity = self.velocity.clamp(
		-Vector3.INF,
		Vector3(max_velo, 100.00, max_velo)
	)
	
	stuck_control()
	move_and_slide()
	
	if is_watching_boss:
		A.face_position(self, boss_actor.global_position)
	return

func tick_control(delta):
	behavior_process_ticker += delta
	if behavior_process_ticker > behavior_process_interval:
		on_behavior_process_tick()
		behavior_process_ticker = 0.0
	
	volatile_data_ticker += delta
	if volatile_data_ticker > volatile_data_ticker_interval:
		on_volatile_data_tick()
		volatile_data_ticker = 0.0
	
	if health < (original_health * .6):
		$indicator.visible = true
	else:
		$indicator.visible = false
	return

func on_behavior_process_tick():
	behavior_control()
	sensor_control()
	return

func on_volatile_data_tick():
	#prints(self.name, "rot diff:", get_rotation_difference())
	recent_global_rotation_degrees = self.global_rotation_degrees
	recent_hits_tracked.pop_back()
	return

func animation_control():
	if is_dancing:
		return
	
	if is_animation_locked:
		return
	
	if is_dead:
		is_animation_locked = true
		anim_h("die1")
		return
	
	if is_door_just_opened and is_moving:
		anim_h("unarmed_run")
		return
	
	if is_dropping_weapon:
		anim_h("pickup_shotgun")
		return
	
	#if self.velocity.length() > movement_threshold:
	if self.velocity.length() > movement_threshold:
		is_moving = true
	else:
		is_moving = false
	
	if is_melee_attacking:
		var melee_attack_anim: String = U.random_choice(
			["melee_attack_1", "melee_attack_2"]
		)
		anim_h("melee_attack_1")
		return
	
	if is_attacking and is_moving:
		anim_h(anim_set["aim_shoot_moving"])
		return
	if is_attacking and not is_moving:
		anim_h(anim_set["aim_shoot"])
		await get_tree().create_timer(1.1).timeout
		return
	
	if not is_attacking and is_recently_attacking and active_weapon_node and is_moving:
		anim_h("armed_run_aim_shoot")
		return
	
	if is_recently_attacking and not anim.assigned_animation:
		anim_h("taunt1")
		return
	
	if is_recently_attacking and anim.assigned_animation and not anim.assigned_animation.contains("melee"):
		return
	
	if active_weapon_node and is_jumping:
		anim_h("armed_jump")
		return
	if not active_weapon_node and is_jumping:
		anim_h("unarmed_jump")
		return
	
	if is_equipping:
		anim_h("pickup_smallarm")
		return
	
	if not overkill_timer.is_stopped() and is_moving:
		anim_h(anim_set["aim_shoot_moving"])
		return
	if not overkill_timer.is_stopped() and not is_moving:
		anim_h(anim_set["aim_shoot"])
		return

	
	if is_recently_attacking and is_moving:
		anim_h(anim_set["aim_shoot_moving"])
		return
	if is_recently_attacking and not is_moving:
		if active_target and (active_target.is_dead or not is_target_viewable()):
			anim_h(anim_set["after_shoot"])
		else:
			anim_h(anim_set["aim_shoot"])
		return
	
	if not active_weapon_node and is_moving and move_speed > BASE_SPEED:
		anim_h("unarmed_sprint")
		return
	if active_weapon_node and is_moving:
		anim_h("armed_run")
		return
	if not active_weapon_node and is_moving:
		anim_h("unarmed_run")
		return
	if active_weapon_node and not is_moving:
		anim_h("armed_idle")
		return
	if not active_weapon_node and not is_moving:
		anim_h("unarmed_idle")
		return
	
	return

func sound_control():
	# Not sure how to do this yet.
	# It has a lot to do with timing.
	if is_moving:
		if $footstep_sound_wait.is_stopped():
			$footstep_sound_wait.start()
	if not is_moving:
		$footstep_sound_wait.stop()
#	if is_equipping:
#		$sounds/pickup_sound.play()
	return

func equip_control():
	if active_weapon_node:
		return
	
	var nearby_weapon: RigidBody3D = get_nearby_dropped_weapon()
	if nearby_weapon:
		pickup_weapon(nearby_weapon.item_name)
		nearby_weapon.queue_free()
		$sounds/pickup_sound.play()
		return
	return

func behavior_control():
	match top_state:
		top_states.NONE:
			return
		
		top_states.SCRIPTED_ANIM:
			return
		
		top_states.IDLE:
			if is_dancing:
				return
			
			if is_door_just_opened:
				is_moving = true
				A.apply_move(self, Vector2.UP, move_speed * .7)
				return
			
			
			if is_moving: A.gradual_velo_stop(self)
			if active_weapon_node and active_weapon_node.get("is_shooting"):
				active_weapon_node.trigger_up()
			
			equip_control()
			if is_equipping:
				return
			
			
			update_targets_by_distance()
			#if active_target and is_target_viewable() and active_weapon_node and not is_attacking:
			if active_target and is_target_viewable() and active_weapon_node and not is_attacking:
				top_state_switch_to(top_states.ATTACK)
				return
			if active_target and is_target_viewable() and not active_weapon_node and not is_attacking:
				top_state_switch_to(top_states.MELEE_ATTACK)
				return
			else:
				# Nothing to do
				#if is_moving: A.gradual_velo_stop(self)
				pass
			return
		
		top_states.FOLLOW_IDLE:
			if is_dancing and boss_actor:
				if A.distance(self, boss_actor) > 10.0:
					toggle_dancing() # off
				
			equip_control()
			if is_equipping:
				return
			if active_weapon_node and active_weapon_node.get("is_shooting"):
				active_weapon_node.trigger_up()
			
			update_targets_by_distance()
			#if active_target and is_target_viewable() and active_weapon_node and not is_attacking:
			if active_target and is_target_viewable() and not is_attacking:
				top_state_switch_to(top_states.FOLLOW_ATTACK)
				return
			
			var boss_distance: float = boss_actor.global_position.distance_to(self.global_position)
			if boss_distance > follow_distance:
				#top_state_switch_to(top_states.FOLLOW_MOVE)
				var is_door_before_boss: bool = check_door_between(boss_actor.global_position)
				if is_door_before_boss:
					teleport_to_boss()
				else:
					top_state_switch_to(top_states.FOLLOW_MOVE)
			return
		
		top_states.FOLLOW_MOVE:
			if is_recently_attacking:
				pass
			
			
			equip_control()
			if is_equipping:
				return
			
			update_targets_by_distance()
			if active_target and is_target_viewable() and not is_attacking and not active_weapon_node:
				top_state_switch_to(top_states.MELEE_ATTACK)
				return
			if active_target and is_target_viewable() and not is_attacking and active_weapon_node:
				top_state_switch_to(top_states.FOLLOW_ATTACK)
				return
			
			
			var boss_distance: float = boss_actor.global_position.distance_to(self.global_position)
			if boss_distance > follow_distance:
				if boss_distance > far_follow_distance:
					move_speed = BASE_SPEED * run_scale
				else:
					move_speed = BASE_SPEED
				
				nav_agent.target_position = boss_actor.global_position
				move_nav()
			else:
				self.velocity = Vector3.ZERO
				if not active_target:
					random_turn()
				
				top_state_switch_to(top_states.FOLLOW_IDLE)
			return
		
		top_states.FOLLOW_ATTACK:
			#update_targets_by_distance()
			if active_target and not active_weapon_node:
				top_state_switch_to(top_states.MELEE_ATTACK)
				return
			if not overkill_timer.is_stopped() and attack_cooloff.is_stopped():
#				if active_target:
#					A.face_position(self, active_target.global_position)
#				elif passive_target:
#					A.face_position(self, passive_target.global_position)
				A.face_position(self, strike_position)
				if is_target_in_melee_range() and A.is_actor_ahead_approx(self, active_target):
					var random_chance: int = randi_range(0, 3)
					if random_chance == 0:
						top_state_switch_to(top_states.MELEE_ATTACK)
					else:
						A.apply_move(self, Vector2.DOWN)
				else:
					strike()
			
			update_targets_by_distance_and_sight()
			if not active_target:
				top_state_switch_to(top_states.FOLLOW_IDLE)
			
			if is_attacking:
				return
			
			if not (active_target and is_target_viewable() and active_weapon_node and not is_attacking):
				top_state_switch_to(top_states.FOLLOW_IDLE)
				return
			
			var boss_distance: float = boss_actor.global_position.distance_to(self.global_position)
			if boss_distance > follow_distance:
				if boss_distance > far_follow_distance:
					move_speed = BASE_SPEED * run_scale
				else:
					move_speed = BASE_SPEED
				
				nav_agent.target_position = boss_actor.global_position
				move_nav(false)
			else:
				self.velocity = Vector3.ZERO
			
			if is_vis_turning:
				return
			
			A.face_position(self, active_target.global_position)
			
			strike_position = active_target.global_position
			strike_position.y += randf_range(3.5, 5.5) #4.0
			strike_raycast.look_at(strike_position, Vector3.UP)
			
			var collider: Node3D = strike_raycast.get_collider()
			if collider != boss_actor:
				if is_target_in_melee_range() and A.is_actor_ahead_approx(self, active_target):
					top_state_switch_to(top_states.MELEE_ATTACK)
				else:
					ghost_strike(active_target)
			return
		
		top_states.ATTACK:
			#update_targets_by_distance()
			update_targets_by_distance_and_sight()
			if not active_target:
				top_state_switch_to(top_states.IDLE)
			
			if is_attacking and is_moving:
				return
			
			if is_attacking:
				return
			
			if not (active_target and is_target_viewable() and active_weapon_node and not is_attacking):
				self.velocity = Vector3.ZERO
				top_state_switch_to(top_states.IDLE)
				return
			
			A.face_position(self, active_target.global_position)
			
			move_speed = BASE_SPEED
			var move_mode: int = 0
			if move_mode == 0:
				# Don't move
				pass
			elif move_mode == 1:
				# Move left and right
				var random_move_input: Vector2 = Vector2(
					randf_range(1.0, -1.0),
					0.0
				)
				var random_move_speed: float = move_speed * randf_range(0.1, 0.6)
				A.apply_move(self, random_move_input, random_move_speed)
			elif move_mode == 2:
				# Move towards target
				var random_move_input: Vector2 = Vector2.UP
				var random_move_speed: float = move_speed * randf_range(0.1, 0.3)
				A.apply_move(self, random_move_input, random_move_speed)
			elif move_mode == 3:
				# Move away from target
				var random_move_input: Vector2 = Vector2.DOWN
				var random_move_speed: float = move_speed * randf_range(0.1, 0.3)
				A.apply_move(self, random_move_input, random_move_speed)
			
			
			strike_position = active_target.global_position
			strike_position.y += randf_range(3.5, 5.5) #4.0
			strike_raycast.look_at(strike_position, Vector3.UP)
			
			var collider: Node3D = strike_raycast.get_collider()
			if collider != boss_actor:
				if is_target_in_melee_range() and A.is_actor_ahead_approx(self, active_target):
					top_state_switch_to(top_states.MELEE_ATTACK)
				else:
					ghost_strike(active_target)
			return
		
		top_states.MELEE_ATTACK:
			if not active_weapon_node:
				equip_control()
			if not active_target and previous_top_state != top_states.MELEE_ATTACK:
				top_state_switch_to(previous_top_state)
				return
			elif not active_target and previous_top_state == top_states.MELEE_ATTACK:
				top_state_switch_to(top_states.IDLE)
				return
			
			if active_target.is_dead:
				active_target = null
				return
			
			# Get close to them
			if self.global_position.distance_to(active_target.global_position) >= melee_distance_threshold:
				if is_door_just_opened:
					is_moving = true
					A.apply_move(self, Vector2.UP, move_speed * .7)
				else:
					nav_agent.target_position = active_target.global_position
					move_nav()
			# Hit them
			else:
				if is_attacking or is_melee_attacking:
					return
				melee_strike(active_target)
			return
		
		top_states.COMMANDED:
			if is_dancing:
				toggle_dancing()
			
			if previous_top_state == top_states.MELEE_ATTACK:
				top_state_switch_to(top_states.IDLE)
				return
			
			if boss_target:
				active_target = boss_target
				
				# If target is viewable, attack them.
				if boss_target.is_dead:
					boss_target = null
					passive_target = active_target
					active_target = null
					
					if previous_top_state == top_states.COMMANDED:
						top_state_switch_to(top_states.IDLE)
					else:
						top_state_switch_to(previous_top_state)
					return
				
				if A.is_actor_viewable(self, sight_raycast, boss_target, 5.0):
					strike_position = active_target.global_position
					strike_position.y += randf_range(3.5, 5.5) #4.0
					strike_raycast.look_at(strike_position, Vector3.UP)
					if attack_cooloff.is_stopped():
						A.face_position(self, boss_target.global_position)
						if not active_weapon_node:
							top_state_switch_to(top_states.MELEE_ATTACK)
						else:
							strike()
				# If not, move towards them.
				else:
					if self.global_position.distance_to(boss_target.global_position) < 15.0:
						if previous_top_state == top_states.COMMANDED:
							top_state_switch_to(top_states.IDLE)
						else:
							top_state_switch_to(previous_top_state)
						return
					nav_agent.target_position = boss_target.global_position
					move_nav(true)
				# If target is dead,
				# return to previous state.
				
			if minion_command_point:
				var distance_reached_threshold: float
				var y_diff_threshold: float = 1.2
				var y_diff: float = absf(self.global_position.y - minion_command_point.y)
				if y_diff > y_diff_threshold:
					distance_reached_threshold = 6.0
				else:
					distance_reached_threshold = 2.0
				
				var command_point_distance: float = self.global_position.distance_to(minion_command_point)
				if command_point_distance < distance_reached_threshold:
					
					if interaction_target:
						interaction_target.interact(self)
						if interaction_target.is_in_group("doors"):
							is_door_just_opened = true
							get_tree().create_tween().tween_callback(func(): is_door_just_opened = false).set_delay(0.7)
						
						interaction_target = null
					minion_command_point = Vector3.ZERO
					
					if not is_door_just_opened:
						self.velocity = Vector3.ZERO
					if previous_top_state == top_states.COMMANDED:
						top_state_switch_to(top_states.IDLE)
					else:
						#top_state_switch_to(previous_top_state) # Don't follow anymore
						top_state_switch_to(top_states.IDLE) # Trying this out
					return
			
				move_nav(true)
			return
			
			print("No boss target, no minion command point.")
			if previous_top_state == top_states.COMMANDED:
				top_state_switch_to(top_states.IDLE)
			else:
				top_state_switch_to(previous_top_state)
			return
	return

func sensor_control():
	is_hit_a_lot = check_if_hit_a_lot()
	
	# Check if nav wiggling
	#if len(recent_nav_positions) > 20:
		#recent_nav_positions.pop_back()
	#if nav_agent.target_position:
		#recent_nav_positions.push_front(nav_agent.get_next_path_position())
	#if len(recent_nav_positions) >= 2:
		#recent_nav_diff = (recent_nav_positions[0] - recent_nav_positions[1]).length_squared()
	#if len(recent_nav_positions) >= 6:
		#is_nav_wiggling()
	return

func check_if_hit_a_lot():
	# If there are 3 little hits within one second
	# OR
	# If the damage of the last hit is more than 20% of health
	if not recent_hits_tracked:
		return false
	
	if recent_hits_tracked[0]["damage"] > (original_health * .20):
		return true
	if len(recent_hits_tracked) >= 3:
		var total_hits: int
		var timeframe_seconds: float = 2.0
		var hit_time_threshold: float = Blackboard.current_world.uptime - timeframe_seconds
		var last_three_hits_within_timeframe: bool = true
		for hit in recent_hits_tracked:
			total_hits += 1
			if total_hits > 3:
				break
			last_three_hits_within_timeframe = hit["time"] > hit_time_threshold
		return last_three_hits_within_timeframe
	return false

func move_nav(face_direction: bool = true, allow_jump: bool = true):
	# Try this first:
	# Only set nav_agent.target_position outside of this function.
	# I don't think it should be set every frame or something, just
	# set it and unset it by situation.
	if is_jumping:
		return
	
	#var next_position: Vector3
	#var navlinks: Array = get_nearby_navlinks()
	#if navlinks:
		#var nearest_navlink: NavigationLink3D = navlinks.pop_front()
		#next_position = nearest_navlink.get_global_end_position()
	#else:
		#next_position = nav_agent.get_next_path_position()
	var next_position: Vector3 = nav_agent.get_next_path_position()
	
	#var dist_to_next_position: float = self.global_position.distance_to(next_position)#debug
	if face_direction:
		A.face_position(self, next_position)
		A.apply_move(self, Vector2(0, -1), move_speed)
	elif not face_direction:
		self.velocity = (next_position - self.global_position).normalized() * move_speed
	
	var chest_collider: Node3D = chest_raycast.get_collider()
	var low_collider: Node3D = low_raycast.get_collider()
	var is_jumpable_ahead: bool = (
		low_collider and not chest_collider and is_instance_of(low_collider, StaticBody3D)
	)
	if is_jumpable_ahead and allow_jump:
		jump()
	return

func move_raw():
	return

func jump():
	if is_jumping:
		return
	is_jumping = true
	if jump_timer.is_stopped():
		jump_timer.start()
	self.velocity.y = JUMP_VELOCITY
	return

func anim_h(anim_name: String, is_queued: bool = true, force_anim: bool = false):
	if anim_name == last_anim and not force_anim:
		return
	anim.play(anim_name)
	if is_queued:
		queued_anims.push_back(anim_name)
	last_anim = anim_name
	return

func random_turn():
	var rand_side: int = randi_range(0, 1)
	var turn_degrees = 45
	if rand_side == 0:
		turn_degrees *= -1
	
	self.rotate_y(deg_to_rad(turn_degrees))
	return

func interact(caller: CharacterBody3D):
	if caller != boss_actor:
		return
	
	if is_dancing:
		toggle_dancing()
	
	if is_never_interacted:
		is_never_interacted = false
	
	#var ack_sounds: Array
	match top_state:
		top_states.IDLE:
			#ack_sounds = $sounds/follow_sounds.get_children()
			top_state_switch_to(top_states.FOLLOW_IDLE)
			caller._minion_follow_start(self)
		top_states.FOLLOW_IDLE:
			top_state_switch_to(top_states.IDLE)
			caller._minion_unfollow_start(self)
		_:
			#ack_sounds = $sounds/stay_sounds.get_children()
			top_state_switch_to(top_states.FOLLOW_IDLE)
			caller._minion_follow_start(self)
	
	await get_tree().create_timer(.6).timeout
	var random_sound_choice: Node3D = U.random_choice_or_nothing(ack_sounds)
	if random_sound_choice:
		random_sound_choice.play()
	return


func top_state_switch_to(new_state: int):
	previous_top_state = top_state
	top_state = new_state
	return

func get_rotation_change():
	# This is working
	# I got confused because sometimes the absolute diff
	# is like 250.
	# This is simple.
	# Something like:
	# If the abs() is greater than ~180, call it a slight turn.
	# If the abs() is between 0 and ~90, call it a slight turn.
	# If the abs() is greater than 90, call it a big turn.
	# If the abs() is around 180, call it a full turn.
	return self.global_rotation_degrees - recent_global_rotation_degrees

func get_nearby_dropped_weapon():
	var closest_weapon: RigidBody3D
	var lowest_distance: float = -1.0
	var weapon_candidates: Array = get_tree().get_nodes_in_group("droppables")
	for candidate in weapon_candidates:
		if candidate.name.contains("ammo"):
			continue
		var candidate_distance: float = self.global_position.distance_to(candidate.global_position)
		if candidate_distance > 5.0:
			continue
		
		if lowest_distance == -1.0:
			lowest_distance = candidate_distance
			closest_weapon = candidate
			continue
		if lowest_distance > -1.0:
			lowest_distance = candidate_distance
			closest_weapon = candidate
			continue
	
	if closest_weapon and lowest_distance != -1.0:
		return closest_weapon
	else:
		return null
	return

func get_target_candidates(group_list: Array[String]):
	var candidates: Array[PhysicsBody3D] = []
	for group in group_list:
		for actor in get_tree().get_nodes_in_group(group):
			candidates.push_front(actor)
	return candidates

func update_targets_by_distance():
	# TODO
	# This will ignore visible targets if a closer target is not viewable.
	# This makes the NPC look stupid, like their range won't reach far away threats.
	var target_candidates: Array = get_target_candidates(groups_i_dont_like)
	var lowest_distance: float = -1.0
	var closest_target: PhysicsBody3D
	if not target_candidates:
		return
	
	for target in target_candidates:
		if target.is_dead:
			continue
		var target_distance: float = self.global_position.distance_to(target.global_position)
		if target_distance < target_distance_threshold:
			if not target in target_pool:
				target_pool.push_front(target)
			if lowest_distance < 0.0:
				lowest_distance = target_distance
				closest_target = target
				continue
			elif lowest_distance > 0.0 and target_distance < lowest_distance:
				lowest_distance = target_distance
				closest_target = target
				continue
			elif lowest_distance > 0.0 and target_distance > lowest_distance:
				continue
	
	if closest_target and lowest_distance < melee_distance_threshold:
		active_target = closest_target
		melee_target = closest_target
	elif closest_target and lowest_distance >= melee_distance_threshold:
		active_target = closest_target
	elif not closest_target:
		passive_target = active_target
		active_target = null
	return

func update_targets_by_distance_and_sight():
	# TODO
	# This will ignore visible targets if a closer target is not viewable.
	# This makes the NPC look stupid, like their range won't reach far away threats.
	var target_candidates: Array = get_target_candidates(groups_i_dont_like)
	var lowest_distance: float = -1.0
	var closest_target: PhysicsBody3D
	if not target_candidates:
		return
	
	for target in target_candidates:
		if target.is_dead:
			continue
		var target_distance: float = self.global_position.distance_to(target.global_position)
		if target_distance < target_distance_threshold:
			if not target in target_pool:
				target_pool.push_front(target)
			if lowest_distance < 0.0:
				lowest_distance = target_distance
				closest_target = target
				continue
			elif lowest_distance > 0.0 and target_distance < lowest_distance and A.is_actor_viewable(self, sight_raycast, target, 5.0):
				lowest_distance = target_distance
				closest_target = target
				continue
			elif lowest_distance > 0.0 and target_distance > lowest_distance:
				continue
	
	if closest_target:
		active_target = closest_target
	elif not closest_target:
		passive_target = active_target
		active_target = null
	return

func is_target_viewable(y_offset: float = 5.0):
#	var y_offset: float = 5.0
	
	if (
		active_target and \
		A.is_actor_viewable(self, sight_raycast, active_target, y_offset)
	):
		return true
	else:
		return false
	return

func recoil_kick(recoil: float):
	var skeleton: Skeleton3D = $model/Armature/Skeleton3D
	var chest_bone_rot: Quaternion = skeleton.get_bone_pose_rotation(2)
	var new_rot: Quaternion = chest_bone_rot
	new_rot = new_rot.normalized()
	new_rot.x -= recoil * 0.01
	#var tween_callable: Callable = skeleton.set_bone_pose_rotation.bind(2)
#	var set_chest_rot: Callable = func(quat_rotation): skeleton.set_bone_pose_rotation(2, quat_rotation)
#	get_tree().create_tween().tween_method(set_chest_rot, chest_bone_rot, new_rot, 1.0)
	skeleton.set_bone_pose_rotation(2, new_rot)
	return

func melee_strike(actor: PhysicsBody3D):
	prints(self.name, "melee strikings")
	is_melee_attacking = true
	actor.hit(melee_damage, U.hit_types.UNDEFINED, self, rhand_anchor.global_position)
	$sounds/hit_sound.play()
	await get_tree().create_timer(melee_attack_cooloff).timeout
	is_melee_attacking = false
	
	if actor.is_dead:
		_hit_taker_died(actor)
	return

func strike(_target: Node3D = null, force_look_at: bool = false):
	if is_dropping_weapon: return
	
	var strike_interval: float
	var is_full_auto: bool = false
	var fire_rate_interval = 60.0 / max_fire_rate
	if active_weapon_node.fire_mode == U.fire_modes.SEMI_AUTO and randomize_attack_time:
		strike_interval = randf_range(fire_rate_interval, fire_rate_interval * 1.2)
	elif active_weapon_node.fire_mode == U.fire_modes.SEMI_AUTO and not randomize_attack_time:
		strike_interval = fire_rate_interval # Might change it, idk
	elif active_weapon_node.fire_mode == U.fire_modes.FULL_AUTO:
		strike_interval = fire_rate_interval
		is_full_auto = true
	elif active_weapon_node.fire_mode == U.fire_modes.SINGLE_ACTION:
		strike_interval = fire_rate_interval # Might change it, idk
	
	attack_cooloff.wait_time = clamp(strike_interval, 0.05, 5.0)
	
	is_attacking = true
	#is_recently_attacking = true
	attack_cooloff.start()
	#extended_attack_cooloff.start()
	
	if force_look_at:
		strike_raycast.look_at(strike_position, Vector3.UP)
	
	active_weapon_node.primary_action(self)
	
	get_tree().create_tween().tween_callback(func(): recoil_kick(active_weapon_node.recoil)).set_delay(0.05)
	get_tree().create_tween().tween_callback(func(): recoil_kick(-active_weapon_node.recoil)).set_delay(0.10)
	
	var is_priming: bool = true if active_weapon_node.get("is_pumping") else false
	if not is_priming:
		var hit_recipient: Node3D = A.create_impact(self, strike_raycast, active_weapon_node.damage)
		
		if hit_recipient and hit_recipient.is_in_group("actors") and hit_recipient.get("is_dead"):
			_hit_taker_died(hit_recipient)
		
		if is_full_auto and is_instance_of(hit_recipient, PhysicsBody3D) and hit_recipient.is_in_group("actors") and hit_recipient.get("is_dead"):
			if overkill_timer.is_stopped():
				overkill_timer.start()
		if not is_full_auto and is_instance_of(hit_recipient, PhysicsBody3D) and hit_recipient.is_in_group("actors") and hit_recipient.is_dead:
			passive_target = null
			active_target = null
		
		active_weapon_ammo_left -= 1
	
	if active_weapon_ammo_left < 1:
		drop_weapon()
	return

func gradual_velo_stop(stop_vec: Vector3 = Vector3.ZERO, duration: float = 1.0):
	var tween: Tween = get_tree().create_tween()
	tween.tween_property(self, "velocity", stop_vec, duration)
	return

func ghost_strike(target: Node3D = null):
	if is_dropping_weapon: return
	
	var strike_interval: float
	var is_full_auto: bool = false
	var fire_rate_interval: float = 60.0 / max_fire_rate
	if active_weapon_node.fire_mode == U.fire_modes.SEMI_AUTO and randomize_attack_time:
		strike_interval = randf_range(fire_rate_interval, fire_rate_interval * 1.2)
	elif active_weapon_node.fire_mode == U.fire_modes.SEMI_AUTO and not randomize_attack_time:
		strike_interval = fire_rate_interval # Might change it, idk
	elif active_weapon_node.fire_mode == U.fire_modes.FULL_AUTO:
		strike_interval = fire_rate_interval
		is_full_auto = true
	elif active_weapon_node.fire_mode == U.fire_modes.SINGLE_ACTION:
		strike_interval = fire_rate_interval # Might change it, idk
	
	attack_cooloff.wait_time = clamp(strike_interval, 0.05, 5.0)
	
	is_attacking = true
	#is_recently_attacking = true
	attack_cooloff.start()
	#extended_attack_cooloff.start()
	
	active_weapon_node.primary_action(self)
	
	get_tree().create_tween().tween_callback(func(): recoil_kick(active_weapon_node.recoil)).set_delay(0.05)
	get_tree().create_tween().tween_callback(func(): recoil_kick(-active_weapon_node.recoil)).set_delay(0.10)
	var hit_recipient: Node3D = A.create_ghost_impact(self, target, active_weapon_node.damage)
	
	if is_instance_of(hit_recipient, PhysicsBody3D) and hit_recipient.is_dead:
		_hit_taker_died(hit_recipient)
	
	if is_full_auto and is_instance_of(hit_recipient, PhysicsBody3D) and hit_recipient.is_dead:
		if overkill_timer.is_stopped():
			overkill_timer.start()
	if not is_full_auto and is_instance_of(hit_recipient, PhysicsBody3D) and hit_recipient.is_dead:
		passive_target = null
		active_target = null
	
	
	var is_priming: bool = true if active_weapon_node.get("is_pumping") else false
	if not is_priming:
		active_weapon_ammo_left -= 1
	
	if active_weapon_ammo_left < 1:
		drop_weapon()
	return

## From w_beretta_nine.gd
#func interact(caller):
#	if caller.is_in_group("players"):
#		caller.ammo_from_item(ammo_type, ammo_count)
#	caller.pickup(item_name, weapon_theme)
#	self.queue_free()
#	return

func pickup(item_name: String, weapon_theme: int = -1):
	if active_weapon_node:
		drop_weapon()
		await self.dropped_weapon
	pickup_weapon(item_name)
	return

func pickup_weapon(weapon_name: String):
	var weapon_item: Dictionary = Weapons.by_name(weapon_name)
	if active_weapon_node:
		active_weapon_node.free()
	
	for c in rhand_anchor.get_children():
		c.free()
	
	is_equipping = true
	equip_delay.start()
	active_weapon_name = weapon_name
	active_weapon_node = weapon_item["scene"].instantiate()
	active_weapon_node.prop_weapon = true
	active_weapon_node.actor = self
	rhand_anchor.add_child(active_weapon_node)
	
	active_weapon_ammo_left = weapon_item["mag_size"]
	active_weapon_mag_size = weapon_item["mag_size"]
	
	if active_weapon_node.fire_mode == U.fire_modes.SEMI_AUTO:
		max_fire_rate = active_weapon_node.fire_rate
		min_fire_rate = 0.0
		anim_set["aim_shoot"] = "aim_shoot_4"
		anim_set["aim_shoot_moving"] = "aim_shoot_4_moving"
		anim_set["after_shoot"] = "after_shoot_1"
	if (
		active_weapon_node.fire_mode == U.fire_modes.FULL_AUTO or \
		active_weapon_node.size == U.weapon_sizes.LONG
	):
		max_fire_rate = active_weapon_node.fire_rate
		min_fire_rate = active_weapon_node.fire_rate
		anim_set["aim_shoot"] = "aim_shoot_smg"
		anim_set["aim_shoot_moving"] = "aim_shoot_smg_moving"
		anim_set["after_shoot"] = "after_shoot_smg"
	if (
		active_weapon_node.fire_mode == U.fire_modes.SINGLE_ACTION and \
		not active_weapon_node.size == U.weapon_sizes.LONG
	):
		max_fire_rate = active_weapon_node.fire_rate
		min_fire_rate = 0.0
		anim_set["aim_shoot"] = "aim_shoot_4"
		anim_set["aim_shoot_moving"] = "aim_shoot_4_moving"
		anim_set["after_shoot"] = "after_shoot_1"
	
	return

func add_health(extra_health: int, overfill: bool = false):
	var new_health: int = health + extra_health
	
	#var start_alpha: float = 0.55
	#var end_alpha: float = 0.0
	#var t_modulate: Tween = get_tree().create_tween()
	#t_modulate.tween_method(
		#func (value): $HUD/addhealth_screen.modulate = value,
		#Color(1.0, 1.0, 1.0, start_alpha),
		#Color(1.0, 1.0, 1.0, end_alpha),
		#.25
	#)
	
	if overfill:
		health = new_health
		return
	
	if not overfill and new_health > health:
		health = 100
		return
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	if is_dead: return
	
	var is_regular_hit: bool = (
		hit_type == U.hit_types.UNDEFINED or \
		hit_type == U.hit_types.RAYCAST or \
		hit_type == U.hit_types.AREA
	)
	#if hit_type == U.hit_types.UNDEFINED:
	if is_regular_hit:
		#health -= damage
		if armor > 0:
			armor -= int(float(damage) * .5)
			if armor < 1:
				armor = 0
				disable_kevlar()
		else:
			health -= damage
		
		recent_hits_tracked.push_front({
			"time": Blackboard.current_world.uptime,
			"damage": damage
		})
		if is_hit_a_lot:
			#A.apply_move(self, Vector2(randf_range(-1, 1), 0), move_speed)
			pass
		
		if health > 0:
			flinch_timer.start()
			is_flinching = true
			var ouch_sounds: Array = $sounds/pain_sounds.get_children()
			ouch_sounds[
				randi_range(0, len(ouch_sounds)-1)
			].play()
			if caller: # and not caller.is_in_group("players"):
				active_target = caller
				A.face_position(self, active_target.global_position)
		if health < 1:
			kill_actor()
	return

func _hit_taker_died(hit_taker: PhysicsBody3D):
	if hit_taker not in actors_killed:
		actors_killed.append(hit_taker)
		prints(self.name, "slayed", hit_taker.name)
		var random_sound_choice: Node3D = U.random_choice_or_nothing($sounds/slay_sounds.get_children())
		if random_sound_choice and U.coin_flip():
			random_sound_choice.play()
	return

func kill_actor():
	if not self.velocity.is_zero_approx():
		gradual_velo_stop()
	is_dropping_weapon = false
	
	top_state_switch_to(top_states.DEAD)
	is_dead = true
	
	for p in get_tree().get_nodes_in_group("players"):
		self.add_collision_exception_with(p)
	return


func _on_flinch_timer_timeout():
	is_flinching = false
	return


func _on_equip_delay_timeout():
	is_equipping = false
	return


func _on_attack_cooloff_timeout():
	is_attacking = false
	# Added
	is_recently_attacking = true
	extended_attack_cooloff.start()
	return


func _on_stuck_timer_timeout():
	var was_stuck = is_stuck
	if was_stuck and not nav_agent.is_target_reachable():
		var boss_too_far_distance: float = 25.0
		if self.global_position.distance_to(nav_agent.target_position) > boss_too_far_distance:
			teleport_to_boss()
		else:
			A.face_position(self, nav_agent.target_position)
			A.apply_move(self, Vector2.UP, move_speed)
			jump()
	return
	
func stuck_control():
	if top_state != top_states.FOLLOW_MOVE and top_state != top_states.FOLLOW_ATTACK:
		return
	
#	if not is_moving:
#		return
	is_stuck = not nav_agent.is_target_reachable()
	if is_stuck and stuck_timer.is_stopped():
		stuck_timer.start()
	return

func banter():
	U.random_choice($sounds/banter_sounds.get_children()).play()
	return

func whatever():
	if U.coin_flip(): banter()
	await get_tree().create_timer(randf_range(0.2, 1.1)).timeout
	self.global_rotation_degrees.y += randf_range(-180, 180)
	return

func boss_command(command_point: Vector3 = Vector3.ZERO):
	if command_point:
		minion_command_point = command_point
		nav_agent.target_position = minion_command_point
	elif not command_point and boss_target:
		nav_agent.target_position = boss_target.global_position
	top_state_switch_to(top_states.COMMANDED)
	return

func is_target_in_melee_range():
	if not active_target:
		return false
	var target_distance: float = self.global_position.distance_to(active_target.global_position)
	return target_distance and target_distance < melee_distance_threshold

func pump_shotgun():
	# Play pump shotgun anim
	anim.play("pump_shotgun")
	return

func drop_weapon():
	if is_dropping_weapon:
		return
	var previous_weapon_ammo_left: int = active_weapon_ammo_left
	is_dropping_weapon = true
	await get_tree().create_timer(tween_estimate_threshold).timeout
	var world_item: RigidBody3D = Weapons.by_name(active_weapon_name)["world_item"].instantiate()
	Blackboard.current_world.add_child(world_item)
	
	var groups_removed: Array = world_item.get_groups()
	for g in world_item.get_groups():
		world_item.remove_from_group(g)
	
	#world_item.get_node("OmniLight3D").light_negative = true
	world_item.global_position = rhand_anchor.global_position
	world_item.rotation_degrees.y = 180
	
	world_item.add_collision_exception_with(self)
	for p in get_tree().get_nodes_in_group("players"):
		world_item.add_collision_exception_with(p) # This shouldn't go here!
	
	world_item.linear_velocity = Vector3(0, 10, 0)
	world_item.angular_velocity = Vector3(0, 0, 5)
	
	for c in rhand_anchor.get_children():
		c.queue_free()
	
	active_weapon_name = ""
	active_weapon_node = null
	active_weapon_ammo_left = 0
	active_weapon_mag_size = 0
	anim.stop()
	anim_set = original_anim_set
	#animation_control()
	
	is_dropping_weapon = false
	
	self.dropped_weapon.emit()
	
	if previous_weapon_ammo_left > 0:
		await get_tree().create_timer(1.0).timeout
		for g in groups_removed:
			world_item.add_to_group(g)
	return

func _on_extended_attack_cooloff_timeout():
	is_recently_attacking = false
	return


func _on_debug_ticker_timeout():
#	prints(
#		self.global_rotation.dot(recent_global_rotation)
#	)
	return


func _on_footstep_sound_wait_timeout():
	var footstep_nodes: Array[AudioStreamPlayer3D] = []
	for c in $sounds.get_children():
		if c.name.contains("footstep"):
			footstep_nodes.append(c)
	var random_footstep_idx: int = randi_range(0, len(footstep_nodes) - 1)
	footstep_nodes[random_footstep_idx].play()
	return


func _on_jump_timer_timeout():
	if self.is_on_floor():
		is_jumping = false
	else:
		jump_timer.start()
	return


func _on_overkill_timer_timeout():
	passive_target = null
	active_target = null
	active_weapon_node.stop_action()
	return

func get_active_ammo_count():
	return active_weapon_ammo_left


#is_door_before_boss: bool = check_door_between(boss_actor.global_position)
				#if is_door_before_boss:
					#teleport_to_boss()
func check_door_between(target_position: Vector3):
	var is_door_between: bool = false
	var target_diff: float = (self.global_position - target_position).length_squared()
	var world_doors: Array = get_tree().get_nodes_in_group("doors")
	for door in world_doors:
		if A.distance(self, door) > BASE_TARGET_DISTANCE_THRESHOLD:
			continue
		var door_diff: float = (self.global_position - door.global_position).length_squared()
		if door_diff < target_diff:
			is_door_between = true
			break
	return is_door_between

func teleport_to_boss():
	if is_recently_teleported:
		return
	is_recently_teleported = true
	self.global_position = lerp(self.global_position, boss_actor.global_position, .75)
	await get_tree().create_timer(1.0).timeout
	is_recently_teleported = false
	return

func add_kevlar(amount: int):
	armor += amount
	if not is_wearing_kevlar:
		enable_kevlar()
	return

func enable_kevlar():
	letterman.visible = false
	kevlar.visible = true
	return

func disable_kevlar():
	return

func get_nearby_navlinks(distance_threshold: float = 9.0):
	var navlinks: Array = get_tree().get_nodes_in_group("navlinks")
	var navlink_candidates: Array = []
	for navlink in navlinks:
		if self.global_position.distance_to(navlink.get_global_start_position()) < distance_threshold:
			navlink_candidates.append(navlink)
	return navlink_candidates

func is_nav_wiggling():
	if len(recent_nav_positions) < 6:
		return false
	
	var diff_pairs: Array = []
	var index_pairs: Array = [
		[1, 2],
		[3, 4],
		[5, 6]
	]
	for index_pair in index_pairs:
		var start_i: int = index_pair[0]
		var end_i: int = index_pair[1]
		diff_pairs.append(recent_nav_positions[start_i] - recent_nav_positions[end_i])
	return

func _dance_alert():
	if is_dancing:
		return
	#if not U.coin_flip():
		#return
	var dance_reaction_time: float = randf_range(0.8, 1.3)
	await get_tree().create_timer(dance_reaction_time).timeout
	toggle_dancing()
	return

func toggle_dancing(dance_name: String = "gesture_carlton_dance"):
	is_dancing = !is_dancing
	if is_dancing:
		#anim_h("gesture_dance_swimcon_1", false, true)
		#var dance_anim: String = "gesture_dance_swimcon_1"
		anim_h(dance_name, false, true)
	return
