extends Node
# "method b"

var receiver: Node
var look_for_receiver: bool = true
var action_state_table: Dictionary = {}
var not_my_receivers: Array = []

func _ready():
	for action in InputMap.get_actions():
		if action.begins_with("ui_"):
			continue
		action_state_table[action] = {}
	
	return

func _unhandled_input(event):
	if not U.is_networked():
		return
	
	if not receiver and look_for_receiver:
		var receiver_guess: Node3D = get_receiver_guess()
		if receiver_guess:
			receiver = receiver_guess
		return
	
	if not receiver:
		#prints(self.name, "No receiver.")
		return
	
	if not "event_queue" in receiver.VirtualInput:
		prints(self.name, "Receiver has no event queue.")
		return
	
	## Actually you'll call RPC on the node and pass the event
	#receiver.VirtualInput.rpc("update_event_queue", event) # Can't pass raw events over RPC
	if event is InputEventMouseMotion:
		var event_dict: Dictionary = U.mouse_motion_to_dict(event)
		receiver.VirtualInput.rpc("update_event_queue", event_dict)
	return


func _physics_process(delta):
	update_action_state_table()
	
	if not not_my_receivers.is_empty():
		for not_my_receiver in not_my_receivers:
			if not not_my_receiver.is_proxy_input_ready:
				not_my_receiver.is_proxy_input_ready = true
				not_my_receiver.process_mode = Node.PROCESS_MODE_INHERIT
		not_my_receivers.clear()
	
	if not receiver and look_for_receiver:
		var receiver_guess: Node3D = get_receiver_guess()
		if receiver_guess:
			receiver = receiver_guess
	
	if not receiver:
		#prints(self.name, "No receiver. #R", randf())
		return
	
	receiver_ready_check.rpc(receiver.get_path())
	receiver.VirtualInput.rpc("update_action_state_table", action_state_table)
	return

@rpc("any_peer", "call_local")
func receiver_ready_check(player_receiver_path: NodePath):
	var player_receiver: Node3D = self.get_node(player_receiver_path)
	#if player_receiver.get_multiplayer_authority() != multiplayer.get_unique_id():
		#pass
	if not player_receiver.is_proxy_input_ready:
		player_receiver.is_proxy_input_ready = true
		player_receiver.process_mode = Node.PROCESS_MODE_INHERIT
	return

func get_receiver_guess():
	if not U.is_networked():
		return
	
	var peer_group: String = "peer_" + str(multiplayer.get_unique_id())
	#var receiver_candidates: Array = get_tree().get_nodes_in_group(peer_group) # Maybe later, right now I just need the player node
	return get_tree().get_first_node_in_group(peer_group)

func update_action_state_table():
	for action in InputMap.get_actions():
		if action.begins_with("ui_"):
			continue
		action_state_table[action]["is_action_just_pressed"] = Input.is_action_just_pressed(action)
		action_state_table[action]["is_action_just_released"] = Input.is_action_just_released(action)
		action_state_table[action]["is_action_pressed"] = Input.is_action_pressed(action)
	
	action_state_table["movekeys_vector"] = Input.get_vector("strafe_left", "strafe_right", "forward", "backward")
	return
