extends Node
# "method a"

var receiver: Node
var look_for_receiver: bool = true

func _ready():
	return

func _unhandled_input(event):
	if not receiver and look_for_receiver:
		var receiver_guess: Node3D = get_receiver_guess()
		if receiver_guess:
			receiver = receiver_guess
		return
	
	if not receiver:
		prints(self.name, "No receiver.")
		return
	
	if not "event_queue" in receiver.VirtualInput:
		prints(self.name, "Receiver has no event queue.")
		return
	
	#receiver.event_queue.clear()
	#receiver.event_queue.append(event)
	## Actually you'll call RPC on the node and pass the event
	receiver.VirtualInput.rpc("update_event_queue", event)
	return


func _process(delta):
	return

func get_receiver_guess():
	var peer_group: String = "peer_" + str(multiplayer.get_unique_id())
	#var receiver_candidates: Array = get_tree().get_nodes_in_group(peer_group) # Maybe later, right now I just need the player node
	return get_tree().get_first_node_in_group(peer_group)
