extends Node3D

var actor: CharacterBody3D
var hand: int = -1
var hud_name: String = "pistol_fifty"
var size: int = U.weapon_sizes.PISTOL
var fire_mode: int = U.fire_modes.SEMI_AUTO
var fire_rate: float = 75.0
@onready var raycast: RayCast3D = $RayCast3D
@onready var anim: AnimationPlayer = $AnimationPlayer
@onready var aim_dot: MeshInstance3D = $aim_dot
@onready var smoke_puff: Sprite3D = $"Lazy Cache/smoke_puff"
var default_shoot_sound_pitch: float = 1
var default_aim_dot_color: Color = Color(1, 1, 1, 1)
@export var target_aim_dot_color: Color = Color(1, 0, 0, 0.5216)
@export var notarget_aim_dot_color: Color = Color(1, 1, 1, 1)

@export var prop_weapon: bool = false
@export var suppress_aimdot: bool = false
var damage: int = 36
var knockback_force: float = 15.0
var recoil: float = 15
var primary_action_type: int = U.primary_action_types.TAP

var csgbox: Resource = preload("res://Scenes/csg_box_subtract_test.tscn")

# Called when the node enters the scene tree for the first time.
func _ready():
	if prop_weapon:
		raycast.enabled = false
		aim_dot.visible = false
	return


func _process(delta):
	if prop_weapon:
		return
	
	aim_dot_control()
	return

func aim_dot_control():
	if suppress_aimdot:
		aim_dot.visible = false
		return
	
	if raycast.is_colliding():
		var collision_point: Vector3 = raycast.get_collision_point()
		var aim_distance: float = self.global_position.distance_to(collision_point)
		if aim_distance < 2.0:
			aim_dot.visible = false
		else:
			aim_dot.visible = true
		
		var aim_dot_material: Material = aim_dot.get_active_material(0)
		var collider: Object = raycast.get_collider()
		if collider and raycast.get_collider().is_in_group("actors"):
			aim_dot_material.albedo_color = target_aim_dot_color #Color(1, 0, 0, 0.5216)
		else:
			aim_dot_material.albedo_color = notarget_aim_dot_color #default_aim_dot_color
		aim_dot.global_position = collision_point
	else:
		aim_dot.visible = false
	return

func impact_control():
	if prop_weapon:
		return
	
	var collider: Object = raycast.get_collider()
	if collider:
		var impact_position = raycast.get_collision_point()
		
		if collider.is_in_group("hit_takers"):
			collider.hit(damage, U.hit_types.UNDEFINED, null, impact_position)
			if is_instance_of(collider, CharacterBody3D) and "health" in collider and collider.health < 1:
				actor._hit_taker_died(collider)
		
		if is_instance_of(collider, RigidBody3D):
			# Stolen from leddit and cleaned up.
			var start_pos: Vector3 = raycast.global_position
			var collision_point: Vector3 = raycast.get_collision_point()
			var impact_direction: Vector3 = start_pos.direction_to(collision_point)
			var impulse = knockback_force * impact_direction
			var relative_position: Vector3 = collision_point - collider.global_position
			collider.apply_impulse(impulse, relative_position)
		
		## CSG TEST
		if is_instance_of(collider, CSGCombiner3D):

			var new_box: CSGMesh3D = csgbox.instantiate()
			collider.add_child(new_box)
			new_box.scale *= 1.5
			new_box.global_position = raycast.get_collision_point()
			call_deferred("debug_func")
		
		var new_smoke_puff: Sprite3D = smoke_puff.duplicate()
		var assumed_world = get_tree().get_first_node_in_group("Worlds")
		assumed_world.add_child(new_smoke_puff)
		new_smoke_puff.global_position = impact_position # raycast.get_collision_point()
		if collider.is_in_group("actors"):
			new_smoke_puff.get_node("AnimationPlayer").play("fade_red")
		else:
			new_smoke_puff.get_node("AnimationPlayer").play("fade")
	return

func shell_casing_control():
	var new_shell_casing: Node3D = $'Lazy Cache/9_mm_shell_casing'.duplicate()
	var assumed_world = get_tree().get_first_node_in_group("Worlds")
	assumed_world.add_child(new_shell_casing)
	new_shell_casing.global_position = $'Lazy Cache/9_mm_shell_casing'.global_position
	new_shell_casing.global_rotation = $'Lazy Cache/9_mm_shell_casing'.global_rotation
	var anim_choice_index: int = randi_range(0, 2)
	var anim_name: String = ["eject", "eject_2", "eject_3"][anim_choice_index]
	new_shell_casing.get_node("AnimationPlayer").play(anim_name)
	new_shell_casing.process_mode = Node.PROCESS_MODE_INHERIT
	return

func semi_auto_shoot(caller):
	anim.stop()
	anim.play("shoot semi")
	impact_control()
	shell_casing_control()
	if not prop_weapon:
		U.spawn_sound_ball(actor, actor.global_position)
		caller.recoil_kick(recoil)
	return

func full_auto_shoot(caller):
	randomize_shoot_pitch()
	anim.play("shoot auto")
	#impact_control()
	return

func stop_action():
	anim.stop()
	anim.play("idle")
	if primary_action_type == U.primary_action_types.HOLD:
		$semi_shoot.pitch_scale = default_shoot_sound_pitch
	return

func randomize_shoot_pitch():
	var new_pitch: float = 0.0
	var first_step: int = randi_range(0, 2)
	if first_step == 0:
		new_pitch = randf_range(1.3, 1.5)
	elif first_step == 1:
		new_pitch = randf_range(1.5, 1.7)
	elif first_step == 2:
		new_pitch = 2.0
	$semi_shoot.pitch_scale = new_pitch
	return

func primary_action(caller):
	semi_auto_shoot(caller)
	return

func reload(caller):
	$reload.play()
	anim.play("reload")
	return

func dry_fire(caller):
	$dry_fire.play()
	return

func _on_delayed_ticker_timeout():
	return


func show_as_empty():
	anim.stop()
	anim.play("empty")
	return

func debug_func():
	prints("FPS after CSG shot:", Engine.get_frames_per_second())
	return
