extends CharacterBody2D

var health: int = 50
@onready var sprite: Sprite2D = $Sprite2D
@onready var anim: AnimationPlayer = $AnimationPlayer
@onready var raycast_container: Node2D = $raycast_container
@onready var punch_raycast: RayCast2D = $raycast_container/punch_raycast
@onready var kick_raycast: RayCast2D = $raycast_container/kick_raycast
@onready var head_raycast: RayCast2D = $raycast_container/head_raycast
var sound_controller: Node

var punch_damage: int = 5
var kick_damage: int = 8
const SPEED = 300.0
const JUMP_VELOCITY = -600.0 # -400.0

# Get the gravity from the project settings to be synced with RigidBody nodes.
var gravity = ProjectSettings.get_setting("physics/2d/default_gravity")
enum {
	DIR_LEFT,
	DIR_RIGHT
}
var facing_direction: int = DIR_RIGHT
var is_punching: bool = false
var is_kicking: bool = false
var is_flinching: bool = false
var is_dead: bool = false

func _ready():
	for raycast in raycast_container.get_children():
		raycast.add_exception(self)
	return

func _physics_process(delta):
	# Add the gravity.
	$Label.text = str(health)
	if not is_on_floor():
		velocity.y += gravity * delta
	
	move_and_slide()
	animation_control()
	return

func set_facing_dir(new_dir: int):
	facing_direction = new_dir
	if facing_direction == DIR_LEFT:
		if sprite.scale.x > 0:
			sprite.scale.x *= -1
			raycast_container.scale.x *= -1
	if facing_direction == DIR_RIGHT:
		if sprite.scale.x < 0:
			sprite.scale.x *= -1
			raycast_container.scale.x *= -1
	return

func animation_control():
	if is_dead:
		anim.play("die")
		return
	
	if is_kicking:
		anim.play("kick")
		return
	
	if is_punching:
		anim.play("punch")
		return
	
	if self.velocity.length() > 0:
		anim.play("walk")
	else:
		anim.play("stand")
	return

func hit(caller: Node2D, damage: int):
	health -= damage
	if health < 1:
		kill_actor()
	if health > 0:
		flinch()
	return

func flinch():
	is_flinching = true
	get_tree().create_tween().tween_callback(
		func(): is_flinching = false
	).set_delay(.2)
	return

func head_punch():
	is_punching = true
	get_tree().create_tween().tween_callback(
		func(): is_punching = false
	).set_delay(.2)
	if head_raycast.get_collider():
		var collider: Object = head_raycast.get_collider()
		collider.hit(self, punch_damage)
		hit_sound()
	return

func head_kick():
	is_punching = true
	get_tree().create_tween().tween_callback(
		func(): is_punching = false
	).set_delay(.2)
	if head_raycast.get_collider():
		var collider: Object = head_raycast.get_collider()
		collider.hit(self, punch_damage)
		collider.velocity.y += JUMP_VELOCITY
		hit_sound()
	return

func punch():
	if is_punching or is_kicking: return
	
	is_punching = true
	get_tree().create_tween().tween_callback(
		func(): is_punching = false
	).set_delay(.2)
	if punch_raycast.get_collider():
		var collider: Object = punch_raycast.get_collider()
		collider.hit(self, punch_damage)
		hit_sound()
	head_punch()
	return

func kick():
	if is_punching or is_kicking: return
	
	
	is_kicking = true
	get_tree().create_tween().tween_callback(
		func(): is_kicking = false
	).set_delay(.2)
	if punch_raycast.get_collider():
		var collider: Object = punch_raycast.get_collider()
		collider.hit(self, kick_damage)
		collider.velocity.y += JUMP_VELOCITY
		hit_sound()
	head_kick()
	return

func kill_actor():
	
	if not sound_controller: set_sound_controller()
	sound_controller.playsound("player_die")
	
	is_dead = true
	$CollisionShape2D.disabled = true
	animation_control()
	velocity.y = JUMP_VELOCITY
	return

func hit_sound():
	if not sound_controller: set_sound_controller()
	sound_controller.playsound("punch")
	return

func set_sound_controller():
	sound_controller = get_tree().get_first_node_in_group("CRIMEBUSTER_sound_controller")
	return

