extends Node3D

signal hurt_interval_timeout

@onready var die_timer: Timer = $die_timer

enum hurt_modes {
	ONE_SHOT,
	ONE_EACH,
	CONSTANT
}
var hurt_mode: int = hurt_modes.ONE_EACH
var is_hurting: bool = false
var hurt_interval: float = .5
var hurt_interval_ticker: float = 0.0
var hurt_proximity: float = 9.0
var hurt_damage: int = 45
var hurt_knockback: float = 0.0
var hurt_sound: AudioStreamPlayer3D
var proxy_hurt_caller: Node3D
@export var stay_alive: bool = false
var exceptions: Array = []
var follow_spatial: Node3D

func _ready():
	connect("hurt_interval_timeout", _on_hurt_interval_timeout)
	if stay_alive:
		die_timer.stop()
	return

func _physics_process(delta):
	
	if follow_spatial:
		self.global_position = follow_spatial.global_position
	
	if hurt_mode == hurt_modes.ONE_EACH:
		hurt()
		return
	
	if hurt_mode == hurt_modes.ONE_SHOT:
		prints(self.name, "one_shot not implemented.")
		return
	
	hurt_interval_ticker += delta
	if hurt_interval_ticker > hurt_interval:
		hurt_interval_ticker = 0.0
		hurt_interval_timeout.emit()
	return

func _on_hurt_interval_timeout():
	if hurt_mode != hurt_modes.CONSTANT:
		return
	
	hurt()
	return

func hurt():
	var hurt_candidates: Array = get_tree().get_nodes_in_group("hit_takers")
	for candidate in hurt_candidates:
		if candidate in exceptions:
			continue
		var dist: float = self.global_position.distance_to(candidate.global_position)
		if dist > hurt_proximity:
			continue
		
		if not is_instance_of(candidate, CharacterBody3D):
			continue
		
		candidate.hit(hurt_damage, U.hit_types.UNDEFINED, proxy_hurt_caller, self.global_position)
		if hurt_knockback:
			A.apply_move(candidate, Vector2.DOWN, hurt_knockback)
			candidate.move_and_slide()
		if hurt_sound:
			hurt_sound.play()
		if hurt_mode == hurt_modes.ONE_EACH:
			exceptions.append(candidate)
	return


func _on_die_timer_timeout():
	self.queue_free()
	return
