extends Node3D

@onready var anim: AnimationPlayer = $rappel_rope/AnimationPlayer
@onready var start_marker: Marker3D = $rope_start/rope_start_pos
@onready var end_marker: Marker3D = $rope_end/rope_end_pos
@export var hide_on_spawn: bool = true

func _ready() -> void:
	if hide_on_spawn:
		self.visible = false
	return

func drop_rope() -> void:
	self.visible = true
	var drop_anim: String = ["drop_1", "drop_2"].pick_random()
	anim.play(drop_anim)
	return

func get_start_pos() -> Vector3:
	return start_marker.global_position

func get_end_pos() -> Vector3:
	return end_marker.global_position
