extends Node3D

@export var die_time: float = 0.0

var position_presets: Dictionary = {
	"none": Vector3(0, 0, 0),
	"player_mid": Vector3(0, 1.0, 0),
	"default_mid": Vector3(0, 4.5, 0)
}

var claimed_positions: Dictionary = {
	"east": null,
	"west": null,
	"north": null,
	"south": null
}

@onready var position_nodes: Dictionary = {
	"north": self.get_node("base/north_anchor/north"),
	"east":  self.get_node("base/east_anchor/east"),
	"south": self.get_node("base/south_anchor/south"),
	"west":  self.get_node("base/west_anchor/west")
}

func _ready():
	if die_time:
		await get_tree().create_timer(die_time).timeout
		self.queue_free()
	return

func set_position_preset(preset_name: String):
	self.position = position_presets[preset_name]
	return

func claim_position(caller: Node3D, position_name: String):
	claimed_positions[position_name] = caller
	prints(self.name, "positions claimed:", claimed_positions)
	return get_rig_position_by_name(position_name)

func unclaim_position(_caller: Node3D, position_name: String):
	claimed_positions[position_name] = null
	return

func find_open_position_name():
	var open_position_name: String
	for rig_position in claimed_positions.keys():
		if claimed_positions[rig_position] == null:
			open_position_name = rig_position
			break
	return open_position_name

func get_rig_position_by_name(position_name: String) -> Vector3:
	if position_name not in position_nodes:
		return Vector3.ZERO
	var relpos_node: Node3D = position_nodes[position_name]
	return relpos_node.global_position
