extends World

var dead_actor_counted: Array = []
var dead_threshold: int = 22
var is_loaded: bool = false

func _ready():
	#prints(self.name, AudioServer.get_bus_volume_db(0))
	AudioServer.set_bus_volume_db(0, -50.00)
	Engine.time_scale = 5.0
	
	if CFG.get_prop("cached"):
		#is_loaded = true
		dead_threshold = 0 # 3
	else:
		await get_tree().create_timer(.1).timeout
		#$brute_force_loader.start_loading()
	return

func _physics_process(delta):
	if is_loaded:
		CFG.set_prop("cached", true)
		start_game()
	$Control/fps_label.text = "f: " + str(Engine.get_frames_per_second())
	return



func _on_timer_timeout():
	check_if_loaded()
	return

func check_if_loaded():
	var dead_count: int = 0
	for actor in dead_actor_counted:
		dead_count += 1
	for actor in get_tree().get_nodes_in_group("actors"):
		if actor.is_dead:
			if dead_actor_counted.has(actor):
				continue
			dead_count += 1
			dead_actor_counted.append(actor)
	
	prints("######", self.name, dead_count)
	if dead_count > dead_threshold:
		for n in $actor_container.get_children():
			n.process_mode = PROCESS_MODE_DISABLED
		for n in $pickup_container.get_children():
			n.process_mode = PROCESS_MODE_DISABLED
		is_loaded = true
	return

func start_game():
	Engine.time_scale = 1.0
	get_tree().change_scene_to_file("res://Scenes/main_menu.tscn")
	return


func _on_fallback_timeout_timeout():
	if not is_loaded:
		start_game()
	return
