extends Node3D

var is_already_interacted: bool = false

func _physics_process(delta):
	var assumed_player: CharacterBody3D = get_tree().get_first_node_in_group("players")
	var player_distance: float = assumed_player.global_position.distance_to(self.global_position)
	#prints(self.name, "player distance:", player_distance)
	if player_distance  < 5.0:
		self.interact(assumed_player)
	return

func interact(_caller: Node3D):
	if is_already_interacted:
		return
	
	$mazander_book_oga/AnimationPlayer.play("booktop_opening_smooth")
	is_already_interacted = true
	return
