extends Node3D

var actor: CharacterBody3D
var hand: int = -1
var hud_name: String = "shotgun_spas12"
var size: int = U.weapon_sizes.LONG
var fire_mode: int = U.fire_modes.SINGLE_ACTION
enum fire_selector_options {
	SEMI,
	PUMP
}
var fire_selector: int = fire_selector_options.SEMI
var fire_rate: float = 115
var sound_distance: float = 80.0
#@onready var raycast: RayCast3D = $RayCast3D
@onready var main_raycast: RayCast3D = $raycast_container/RayCast3D
var raycast: RayCast3D
@onready var raycast_container: Node3D = $raycast_container
@onready var anim: AnimationPlayer = $AnimationPlayer
@onready var aim_dot: MeshInstance3D = $aim_dot
var default_shoot_sound_pitch: float = 1
var default_aim_dot_color: Color = Color(1, 1, 1, 1)
@export var target_aim_dot_color: Color = Color(1, 0, 0, 0.5216)
@export var notarget_aim_dot_color: Color = Color(1, 1, 1, 1)

@export var prop_weapon: bool = false
@export var suppress_aimdot: bool = false

@onready var shoot_sounds: Array = $shoot_sound_container.get_children()

var damage: int = 44
var knockback_force: float = 15.0
var recoil: float = 12.0
var primary_action_type: int = U.primary_action_types.HOLD
var is_shooting: bool = false
var shoot_caller: Node
#var shoot_time: float = 0.1
var callback_data: Dictionary
var finished_shot_callback: Callable
var shoot_tick_counter: float = -1.0

var csgbox: Resource = preload("res://Scenes/csg_box_subtract_test.tscn")

var is_pumped: bool = true
var is_pumping: bool = false
enum shotgun_action_states {
	SHOOTING,
	PUMPING
}
var shotgun_action_state: int = shotgun_action_states.SHOOTING


func _ready():
	raycast = main_raycast # For compatibility
	
	if prop_weapon:
		for raycast in raycast_container.get_children():
			raycast.enabled = false
		aim_dot.visible = false
	return


func _process(delta):
	if not prop_weapon:
		aim_dot_control()
	
	#if is_shooting and is_pumped:
		##shoot_tick_counter += delta
		##if shoot_tick_counter > (60/fire_rate):
		#if shoot_tick_counter < 0.0:
			#shoot()
			#shoot_tick_counter = (60/fire_rate)
		#
		#shoot_tick_counter -= delta
	return

func aim_dot_control():
	if suppress_aimdot:
		aim_dot.visible = false
		return
	
	if main_raycast.is_colliding():
		var collision_point: Vector3 = main_raycast.get_collision_point()
		var aim_distance: float = self.global_position.distance_to(collision_point)
		if aim_distance < 2.0:
			aim_dot.visible = false
		else:
			aim_dot.visible = true
		
		var aim_dot_material: Material = aim_dot.get_active_material(0)
		var collider: Object = main_raycast.get_collider()
		if collider and main_raycast.get_collider().is_in_group("actors"):
			aim_dot_material.albedo_color = target_aim_dot_color #Color(1, 0, 0, 0.5216)
		else:
			aim_dot_material.albedo_color = notarget_aim_dot_color #default_aim_dot_color
		aim_dot.global_position = collision_point
	else:
		aim_dot.visible = false
	return

func shell_casing_control():
	var new_shell_casing: Node3D = $'Lazy Cache/shotgun_shell_casing'.duplicate()
	var assumed_world = get_tree().get_first_node_in_group("Worlds")
	assumed_world.add_child(new_shell_casing)
	new_shell_casing.global_position = $'Lazy Cache/shotgun_shell_casing'.global_position
	new_shell_casing.global_rotation = $'Lazy Cache/shotgun_shell_casing'.global_rotation
	var anim_choice_index: int = randi_range(0, 2)
	var anim_name: String = ["eject", "eject_2", "eject_3"][anim_choice_index]
	new_shell_casing.get_node("AnimationPlayer").play(anim_name)
	new_shell_casing.process_mode = Node.PROCESS_MODE_INHERIT
	return

func semi_auto_shoot(caller):
	anim.stop()
	anim.play("shoot semi")
	#impact_control()
	return

func full_auto_shoot(caller):
	randomize_shoot_pitch()
	if is_shooting:
		return
	
	#$shoot_timer.start(shoot_time)
	is_shooting = true
	anim.play("shoot auto")
	#impact_control() # Called in animation
	if not prop_weapon:
		U.spawn_sound_ball(actor, actor.global_position)
		caller.recoil_kick(recoil)
	return

func stop_action():
	trigger_up()
	
	anim.stop()
	anim.play("idle")
	if primary_action_type == U.primary_action_types.HOLD:
		for shoot_sound in shoot_sounds:
			shoot_sound.pitch_scale = default_shoot_sound_pitch
	return

func randomize_shoot_pitch():
	var new_pitch: float = randf_range(0.9, 1.1)
	#var first_step: int = randi_range(0, 2)
	#if first_step == 0:
		#new_pitch = randf_range(1.3, 1.5)
	#elif first_step == 1:
		#new_pitch = randf_range(1.5, 1.7)
	#elif first_step == 2:
		#new_pitch = 2.0
	for shoot_sound in shoot_sounds:
		shoot_sound.pitch_scale = new_pitch
	return

func primary_action(caller):
	#full_auto_shoot(caller)
	if caller.is_in_group("players"):
		trigger_down(caller)
	else:
		trigger_down(caller)
		await get_tree().create_timer(.3).timeout
		trigger_up()
	
	return

func trigger_down(caller: Node):
	if is_shooting or is_pumping:
		return
	
	shoot_caller = caller
	
	if shotgun_action_state == shotgun_action_states.SHOOTING:
		#is_shooting = true
		
		if fire_selector == fire_selector_options.SEMI:
			is_shooting = true
		
		if (actor.is_in_group("players") and not actor.is_covercarrot) and not fire_selector == fire_selector_options.SEMI:
			actor.anim.stop()
			await get_tree().create_timer(.06).timeout # Keep the gun from shooting way off target mid-pump
		
		shoot()
	elif shotgun_action_state == shotgun_action_states.PUMPING:
		pump()
	return

func trigger_up():
	shoot_caller = null
	is_shooting = false # Maybe move into the SHOOTING block, maybe not. idk.
	if fire_selector == fire_selector_options.SEMI:
		is_pumped = true
	
	if shotgun_action_state == shotgun_action_states.SHOOTING and not is_pumped:
		shotgun_action_state = shotgun_action_states.PUMPING
	elif shotgun_action_state == shotgun_action_states.PUMPING and is_pumped:
		is_pumping = false
		shotgun_action_state = shotgun_action_states.SHOOTING
	return

func shoot():
	if not is_pumped:
		return
	randomize_shoot_pitch()
	anim.play("shoot")
	U.random_choice(shoot_sounds).play()
	#A.create_impact(actor, raycast, damage, knockback_force)
	var per_raycast_damage: int = int(damage / raycast_container.get_child_count())
	var per_raycast_knockback_force: float = knockback_force / raycast_container.get_child_count()
	for raycast in raycast_container.get_children():
		A.create_impact(actor, raycast, per_raycast_damage, per_raycast_knockback_force)
	
	
	if not prop_weapon:
		U.spawn_sound_ball(actor, actor.global_position, sound_distance)
		if shoot_caller:
			shoot_caller.recoil_kick(recoil)
	
	is_pumped = false
	
	if fire_selector == fire_selector_options.SEMI:
		shell_casing_control()
	
	# Called immediately and not after the animation.
	# I don't think that's a problem.
	if finished_shot_callback:
		finished_shot_callback.call(callback_data["hand"], callback_data["iid"])
	return

func reload(caller):
	$reload.play()
	anim.play("reload")
	anim.queue("idle")
	return

func dry_fire(caller):
	stop_action()
	$dry_fire.play()
	return

func _on_delayed_ticker_timeout():
	return

func show_as_empty():
	anim.stop()
	anim.play("empty")
	return

func pump():
	$shotgun_spas12/AnimationPlayer.play("pump")
	actor.pump_shotgun()
	$pump_sound.play()
	is_pumping = true
	is_pumped = true
	shell_casing_control()
	return
