extends Node3D

@onready var rigidbody_smoke: RigidBody3D = $RigidBody3D
var windiness: float = 1.0
var wind_force: float = 14.21
var wind_direction_y: float = 0.0
var visual_strength: float = 1.0
var fade_time: float = 7.0 # 13.0 # s
var smoke_meshes: Array = []

func _ready() -> void:
	for smoke_mesh in self.find_children("*", "MeshInstance3D"):
		smoke_meshes.append(smoke_mesh)
		get_tree().create_tween().tween_property(
			smoke_mesh,
			"transparency",
			1.0,
			fade_time
		)
	return

func _physics_process(delta: float) -> void:
	if smoke_meshes[0].transparency == 1.0:
		return
	
	wind_direction_y += randf_range(-wind_force, wind_force)
	rigidbody_smoke.apply_force(
		(Vector3.FORWARD * (wind_force * windiness)).rotated(Vector3.UP, wind_direction_y)
	)
	return
