extends VehicleBody3D

@onready var car_model: Node3D = $ggbot_crown_edit
@onready var debug_controller: Node3D = $debug/debug_controller
@onready var label_1: Label = $Control/label_1
@onready var label_2: Label = $Control/label_2
@onready var label_3: Label = $Control/label_3
var engine_force_loss: float = 200.0
var steering_loss: float = 200.0 # 200 stiff
var is_handbraking: bool = false
var handbrake_angular_velocity: Vector3 = Vector3.ZERO

func _ready():
	# Add collision exception with the static bodies in the vehicle node
	for c in self.find_children("*", "StaticBody3D", true):
		self.add_collision_exception_with(c)
	debug_controller.vehicle = self
	debug_controller._post_init()
	return

func _physics_process(delta: float) -> void:
	label_1.text = str(self.linear_velocity)
	label_2.text = str(self.engine_force)
	label_3.text = str(self.angular_velocity) + " / " + str(self.steering)
	
	if self.engine_force > 0:
		self.engine_force -= engine_force_loss
	if self.engine_force < 0:
		self.engine_force += engine_force_loss
	
	if self.steering > 0 and not self.is_handbraking:
		self.steering -= steering_loss
	if self.steering < 0 and not self.is_handbraking:
		self.steering += steering_loss
	
	if absf(self.steering) > 1.0:
		handbrake_angular_velocity = self.angular_velocity
	
	#if absf(self.steering) > 0 and absf(self.steering) < 1:
		#if is_handbraking:
			#pass
		#elif not is_handbraking:
			#self.steering = 0.0
	return
