extends Node3D

@onready var vehicle: VehicleBody3D
var is_input_allowed: bool = false
var raw_vehicle_force: float = 300.00
var brake_scale: float = .8
var steering_force: float = 200.00
const MAX_ENGINE_INPUT: float = 999.00

func _post_init():
	return

func _physics_process(delta: float) -> void:
	if Input.is_action_pressed("forward"):
		vehicle.engine_force += -raw_vehicle_force
		prints(self.name, vehicle.engine_force, vehicle.get_node("wheel_front_right").get_contact_body())
	if Input.is_action_pressed("backward"):
		vehicle.engine_force += raw_vehicle_force
	if Input.is_action_pressed("strafe_left"):
		vehicle.steering -= steering_force
	if Input.is_action_pressed("strafe_right"):
		vehicle.steering += steering_force
	if Input.is_action_pressed("jump"):
		if not is_zero_approx(vehicle.engine_force):
			vehicle.engine_force = lerpf(
				vehicle.engine_force,
				0,
				brake_scale
			)
		vehicle.is_handbraking = true
	elif not Input.is_action_pressed("jump"):
		vehicle.is_handbraking = false
	return
