extends StaticBody3D

var time_to_die: float = 3.2

# Called when the node enters the scene tree for the first time.
func _ready():
	# Init time
	await get_tree().create_timer(1.0).timeout
	if time_to_die:
		$spray_sound.play()
		await get_tree().create_timer(time_to_die).timeout
		explode()
	return


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	return

func explode():
	$spray_sound.stop()
	$generic_canister.visible = false
	for n in self.find_children("spray_*"):
		n.visible = false
	$explosion.activate(self)
	await get_tree().create_timer(1.5).timeout
	self.queue_free()
	return
