extends RigidBody3D

@export var weapon_theme: U.weapon_themes = U.weapon_themes.LIGHT
@export var drop_and_freeze: bool = true
var item_name: String = "beretta_nine_r"
@export var ammo_count: int = 25
var ammo_type: int = U.ammo_types.NINE_MM

var just_spawned: bool = true

func _ready():
	connect("body_entered", _body_entered)
	
	if weapon_theme == U.weapon_themes.DARK:
		set_dark_weapon_theme()
	return

func _on_area_3d_body_entered(body):
	if body.is_in_group("players") and self.is_in_group("interactables"):
		var has_ammo: bool = ammo_count > 0
		$OmniLight3D.visible = true if has_ammo else false
		if A.distance(body, self) < 5 and ammo_count > 0 and body.has_method("ammo_from_item"):
			body.ammo_from_item(ammo_type, ammo_count)
			ammo_count = 0
	return


func _on_area_3d_body_exited(body):
	if body.is_in_group("players"):
		$OmniLight3D.visible = false
	return

func interact(caller):
	#if caller.is_in_group("players"):
		#caller.ammo_from_item(ammo_type, ammo_count)
	if caller.is_in_group("players") and ammo_count > 0:
		caller.ammo_from_item(ammo_type, ammo_count)
	#caller.pickup(item_name, weapon_theme)
	caller.pickup(item_name)
	self.queue_free()
	return

func _body_entered(body):
	$clack_sound.play()
	return


func _on_spawn_cooloff_timeout():
	just_spawned = false
	return


func _on_rest_timer_timeout():
	if not drop_and_freeze: return
	freeze = true # This isn't needed, thought it would solve a performance issue
	return

func set_dark_weapon_theme():
	$pistol_beretta/armature/Body.set_surface_override_material(1, load("res://Resources/generic_dark_grey_material.tres"))
	$pistol_beretta/armature/Skeleton3D/Slid.set_surface_override_material(0, load("res://Resources/generic_lessdark_grey_material.tres"))
	return
