extends RigidBody3D

var item_name: String = "m3a1_45mm"
@export var ammo_count: int = (30*2)
var ammo_type: int = U.ammo_types.FORTY_FIVE

func _ready():
	connect("body_entered", _body_entered)
	return

func _on_area_3d_body_entered(body):
	if body.is_in_group("players") and self.is_in_group("interactables"):
		#$OmniLight3D.visible = true
		var has_ammo: bool = ammo_count > 0
		$OmniLight3D.visible = true if has_ammo else false
		if A.distance(body, self) < 5 and ammo_count > 0 and body.has_method("ammo_from_item"):
			body.ammo_from_item(ammo_type, ammo_count)
			ammo_count = 0
	return


func _on_area_3d_body_exited(body):
	if body.is_in_group("players"):
		$OmniLight3D.visible = false
	return

func interact(caller):
	#if caller.is_in_group("players"):
		#caller.ammo_from_item(ammo_type, ammo_count)
	if caller.is_in_group("players") and ammo_count > 0:
		caller.ammo_from_item(ammo_type, ammo_count)
	caller.pickup(item_name)
	self.queue_free()
	return

func _body_entered(body):
	$clack_sound.play()
	return
