extends Node

@onready var actor: CharacterBody3D = get_parent()
enum top_states {
	STAND_STILL,
	TWO_POINT_PATROL,
	ROAM,
	ENGAGE_TARGET
}
@export var top_state: int = top_states.STAND_STILL
var actor_ready: bool = false
var target_pool: Array[CharacterBody3D]
var active_target: CharacterBody3D

var groups_i_dont_like: Array[String] = [
	"players"
]

const GOOFY_INVALID_NUMBER: float = -123.456
var engage_distance: float = 55
var base_engage_distance: float = engage_distance

func init():
	top_state = actor.spawn_state
	for group in groups_i_dont_like:
		var group_children: Array = get_tree().get_nodes_in_group(group)
		target_pool.append_array(group_children)
		# FIXME:
		# What happens if a new one spawns after init?
		# I think maybe subscribe to tree entry signals.
		# Specifically for containers (enemy containers, player containers, etc.)
	for state_node in self.get_children():
		state_node.brain = self
		state_node.actor = self.get_parent()
	return

func _process(delta):
	if not actor_ready: return
	
	state_control(delta)
	return

func state_control(delta):
	var state_node: Node
	match top_state:
		top_states.STAND_STILL:
			state_node = $stand_still
		top_states.TWO_POINT_PATROL:
			pass
		top_states.ROAM:
			pass
		top_states.ENGAGE_TARGET:
			state_node = $engage_target
	
	state_node.act(delta)
	return

func update_nearby_targets():
	var closest_target: CharacterBody3D
	var lowest_dist: float = GOOFY_INVALID_NUMBER
	for target in target_pool:
		
		var target_dist: float = check_target_distance(target.global_position)
		if target_dist == GOOFY_INVALID_NUMBER:
			continue
		if target_dist > engage_distance:
			continue
		if (lowest_dist == GOOFY_INVALID_NUMBER) or (target_dist < lowest_dist):
			lowest_dist = target_dist
			closest_target = target
			continue
	if closest_target:
		active_target = closest_target
	else:
		active_target = null
	return

func check_target_distance(target_pos: Vector3):
	if not actor: return GOOFY_INVALID_NUMBER
	return actor.global_position.distance_to(target_pos)

func set_state(new_state: int):
	var previous_state: int = top_state
	get_node(
		top_states.keys()[new_state].to_lower()
	)._on_switch(previous_state)
	
	top_state = new_state
	return




#### TESTING ####
func load_testing():
	var player: Node3D = get_tree().get_first_node_in_group("players")
	var target_dist: float = actor.global_position.distance_to(player.global_position)
	if target_dist < 20.0:
		prints("PLAYER is close to fatboy", actor.name ,"with a distance of", target_dist)
	return

