extends Node

@onready var brain: Node = get_parent()
var actor: CharacterBody3D

var engage_distance: float = 55
var main_ticker: float = 0.0
var distance_check_ticker: float = 0.0
var distance_check_interval: float = 0.5
const GOOFY_INVALID_NUMBER: float = -123.456

enum states {
	NONE,
	WAITING,
	THROWING,
	TAUNTING
}
var current_state: int = states.WAITING
var previous_state: int = states.WAITING

func _ready():
	$throw_interval.connect("timeout", _throw_interval_timeout)
	return

func act(delta):
	# Is the target in range?
	main_ticker += delta
	distance_check_ticker += delta
	if distance_check_ticker > distance_check_interval:
		brain.update_nearby_targets()
		distance_check_ticker = 0.0
		set_debug_text(states.keys()[current_state])
	
	return

func engage_target():
	match current_state:
		states.WAITING:
			
			if not brain.active_target:
				return

			
			var is_target_visible: bool = check_target_visibility(brain.active_target)
			if is_target_visible:
				set_state(states.THROWING)
			elif not is_target_visible and brain.active_target:
				brain.actor.anim_h("armed_idle")
		states.THROWING:
			# The throwing interval timer will handle throws.
			# Here just make sure throwing is possible
			# - Can you still see the player?
			# - Is the player still in range?
			#var is_target_visible: bool = check_target_visibility(brain.active_target)
			#if not is_target_visible:
			#	set_state(states.WAITING)
			pass

		states.TAUNTING:
			# Eeyyyy
			pass
	return

func _on_switch(_previous_state: int):
	taunt()
	return

func taunt():
	current_state = states.TAUNTING
	brain.actor.anim_h("comm_over_there")
	await get_tree().create_timer(1.0).timeout
	current_state = previous_state
	return

func check_target_visibility(target_arg: CharacterBody3D):
	var from_pos: Vector3 = brain.actor.rhand_anchor.global_position
	#from_pos.y += 1
	var to_pos: Vector3 = target_arg.global_position
	to_pos.y += 0.5
	
	var ray_result: Dictionary = U.world_raycast(self.brain.actor, from_pos, to_pos, [])
	
	if not ray_result:
		return false
	if ray_result and ray_result["collider"] == target_arg:
		return true
	else:
		return false
	return ray_result

func set_state(new_state: int):
	#var previous_state: int = current_state
	current_state = new_state
	return

func _throw_interval_timeout():
	if not current_state == states.THROWING:
		return
	
	throw_knife()
	return

func throw_knife():
	brain.actor.anim_h("throw_overhand", false, true)
	return

func set_debug_text(new_text: String):
	brain.actor.debug_label.text = new_text
	return