extends Node

@onready var brain: Node = get_parent()
var actor: CharacterBody3D

var engage_distance: float = 55
var main_ticker: float = 0.0
var distance_check_ticker: float = 0.0
var distance_check_interval: float = 0.5
const GOOFY_INVALID_NUMBER: float = -123.456

## NEXT
# Literally just stand still and sense things.
# Send sensed information up to the fat_brain so it can manage states

func act(delta):
	# Is the target in range?
	main_ticker += delta
	distance_check_ticker += delta
	if distance_check_ticker > distance_check_interval:
		brain.update_nearby_targets()
		distance_check_ticker = 0.0
	
	if brain.active_target:
		brain.set_state(brain.top_states.ENGAGE_TARGET)
	else:
		brain.actor.anim_h("unarmed_idle")
	return

func _on_switch(_previous_state: int):
	return
