extends World

@onready var map: TBLoader = $NavigationRegion3D/Map
var expected_enemy_groups: Array = ["mooks", "punks", "burglars", "clowns_freeling", "wiseguys", "h_grunts"]
var total_enemies: int
var debug_store: Dictionary = {"node_counter": {}}
var total_time: float = 0.0
var is_exit_triggered: bool = false
var is_grunt_entry_audio_triggered: bool = false
var is_scene_endable: bool = false

#var intermission_loop_scene: Resource = preload("res://Scenes/intermission_loop.tscn")
var full_init: bool = false

var is_exit_camera_flickering: bool = false
var exit_camera_delta: float = 0.0
var exit_camera_interval: float = .001
var exit_camera_index: int = 0
@onready var exit_cameras: Array = [
	$External/Exit/exit_camera_1,
	$External/Exit/exit_camera_2
]
@onready var exit_player_pos: Marker3D = $External/Exit/exit_player_pos
@onready var exit_light: Node3D = $External/Exit/exit_light
@onready var exit_music: AudioStreamPlayer3D = $External/Exit/exit_music
@onready var exit_screen: Control = $External/Exit/exit_screen
var keep_player_inventory: bool = true

var is_stairgrunts_triggered: bool = false
var is_helozone_triggered: bool = false

func _enter_tree() -> void:
	windows_crash_fix()
	return

func _ready():
	for c in get_tree().get_nodes_in_group("world_inits"):
		c._on_world_ready()
	
	if keep_player_inventory and not Global.prop_table["slot_manager_cache"].is_empty():
		#U.grptop("players").load_saved_inventory()
		U.grptop("players").load_life_state()
	
	for enemy_group in expected_enemy_groups:
		total_enemies += len(get_tree().get_nodes_in_group(enemy_group))
	
	for light_controller in get_tree().get_nodes_in_group("entry_lights"):
		if light_controller.rolename == "lightswitch":
			light_controller.switched.connect(_on_entry_light_switch)
	
	await get_tree().create_timer(.5).timeout
	full_init = true
	
	
	exit_player_pos.reparent(get_tree().get_first_node_in_group("exit_elevator"))
	exit_light.reparent(get_tree().get_first_node_in_group("exit_elevator"))
	exit_music.reparent(get_tree().get_first_node_in_group("exit_elevator"))
	
	spin_rope()
	
	get_tree().create_tween().tween_callback(
		func ():
			var darkentrydoor: Object = get_tree().get_first_node_in_group("darkentrydoor1")
			if not darkentrydoor:
				return
			darkentrydoor.activate()
			#if not $enemy_container/Grunts/h_grunt_20.is_dead:
				#$enemy_container/Grunts/h_grunt_20.active_target = get_tree().get_first_node_in_group("players")
	).set_delay(7.3)
	
	###
	$NavigationRegion3D/Map/terminal_keycard.activated.connect(_reddoor_activated)
	for light_controller in get_tree().get_nodes_in_group("cafe_flourlights_1"):
		if light_controller.rolename == "lightswitch":
			light_controller.switched.connect(_on_entry_light_switch)
	return

func _physics_process(delta):
	if not full_init: return
	
	total_time += delta
	
	if is_scene_endable and Input.is_anything_pressed():
		scene_ended.emit()
	
	if is_exit_camera_flickering:
		
		exit_camera_delta += delta
		if exit_camera_delta >= exit_camera_interval:
			var offset: float = 0.002
			exit_cameras[0].position.x -= offset# * .6
			exit_cameras[1].position.x += offset * .6
			exit_cameras[1].position.z += offset
			exit_cameras[1].position.y -= offset * 1.7
			
			exit_camera_delta = 0.0
			exit_cameras[exit_camera_index].make_current()
			if exit_camera_index == 1:
				exit_camera_index = 0
			elif exit_camera_index == 0:
				exit_camera_index = 1
	return

# 


func exit_level():
	if is_exit_triggered:
		return
	
	is_exit_triggered = true
	Engine.time_scale = 0.4 # .2
	var player: Node3D = U.grptop("players")
	player.exit_mode = true
	player.hud.visible = false
	player.velocity = Vector3.ZERO
	#player.toggle_dancing("gesture_dance_head_shake_1")
	
	#player.global_position = exit_player_pos.global_position
	#player.global_rotation = exit_player_pos.global_rotation
	
	
	exit_light.get_node("AnimationPlayer").play("flash")
	exit_light.get_node("AnimationPlayer").speed_scale = 2.0
	
	
	#exit_music.play(41.9)
	exit_music.play()
	is_exit_camera_flickering = true
	await get_tree().create_timer(0.3).timeout
	#$External/Exit/exit_screen.visible = true
	trigger_exit_canvas()
	await get_tree().create_timer(2.0).timeout
	is_scene_endable = true
	await get_tree().create_timer(23.0).timeout
	is_exit_camera_flickering = false
	get_tree().get_first_node_in_group("black_camera").make_current()

	return




func trigger_exit_canvas():
	exit_screen.visible = true
	var enemies_alive: int = 0
	for enemy_group in expected_enemy_groups:
		for enemy in get_tree().get_nodes_in_group(enemy_group):
			if not enemy.is_dead:
				enemies_alive += 1
	
	var total_kills: String = str(total_enemies - enemies_alive)
	var credits_amount: String = "0"
	if Global.prop_table["credits"].has(get_tree().get_first_node_in_group("players").offline_id):
		credits_amount = str(Global.prop_table["credits"][get_tree().get_first_node_in_group("players").offline_id])
	#var exit_screen: Control = $External/Exit/exit_screen
	exit_screen.get_node("Label_Kills").text = "KILLS: " + total_kills + " / " + str(total_enemies)
	exit_screen.get_node("Label_Time").text = "TIME: " + str(snappedf(total_time, 0.1))
	exit_screen.get_node("Label_Credits").text = "CREDS: " + credits_amount
	exit_screen.get_node("Label_Time").visible = true
	exit_screen.get_node("Label_Kills").visible = true
	exit_screen.get_node("Label_Credits").visible = true
	return


func spin_rope() -> void:
	var map: Node3D = $NavigationRegion3D/Map
	var rope: Node3D = map.find_child("ropedec-nocol")
	get_tree().create_tween().tween_property(
		rope,
		"global_rotation_degrees:y",
		360.0,
		0.4
	)
	return


func _on_stairs_grunt_trigger_body_entered(body: Node3D) -> void:
	if is_stairgrunts_triggered:
		return
	if not body.is_in_group("players"):
		return
	
	is_stairgrunts_triggered = true
	for w in get_tree().get_nodes_in_group("stairs_skyglass_1"):
		w.kill_glass()
	
	#await get_tree().create_timer(.8).timeout
	for g in $"enemy_container/Rappel Grunts/".find_children("h_grunt_*"):
		g.rope_drop_ready = true
	return

func _on_entry_light_switch(light_state: bool) -> void:
	# Alert grunt no matter which way it's switched
	get_tree().get_first_node_in_group("entry_grunt").active_target = get_tree().get_first_node_in_group("players")
	return


func _on_grunt_audio_trigger_body_entered(body: Node3D) -> void:
	if not body.is_in_group("players"):
		return
	if is_grunt_entry_audio_triggered:
		return
	
	$enemy_container/Grunts/h_grunt_2.play_special_audio("bravo_helo")
	is_grunt_entry_audio_triggered = true
	return


func _reddoor_activated():
	if is_helozone_triggered:
		return
	
	$enemy_container/helo_zone.process_mode = Node.PROCESS_MODE_INHERIT
	await get_tree().create_timer(4.3).timeout
	for w in get_tree().get_nodes_in_group("helozone_ropeglass_1"):
		w.kill_glass()
	await get_tree().create_timer(0.8).timeout
	for g in $enemy_container/helo_zone/Grunts/Rappel.find_children("h_grunt_*"):
		g.rope_drop_ready = true
	return

func _on_cafe_flourlights_1_light_switch(light_state: bool) -> void:
	for grunt in [
		$enemy_container/Grunts/h_grunt_15,
		$enemy_container/Grunts/h_grunt_16,
		$enemy_container/Grunts/h_grunt_17
	]:
		grunt.target_distance_threshold = 21.0
	
	return


func _on_killpit_ticker_timeout() -> void:
	for g in ["players", "h_grunts"]:
		for actor in get_tree().get_nodes_in_group(g):
			if not actor:
				continue
			if actor.is_dead:
				continue
			if actor.global_position.y < -400:
				actor.hit(9999, U.hit_types.AREA, null, actor.global_position)
	return


func _on_keycard_taken() -> void:
	$enemy_container/Clowns/clown_freeling_bomber_2.process_mode = Node.PROCESS_MODE_INHERIT
	$enemy_container/Clowns/clown_freeling_bomber_2.visible = true
	return


func _on_exit_trigger_body_entered(body: Node3D) -> void:
	if is_exit_triggered:
		return
	if not body.is_in_group("players"):
		return
	
	exit_level()
	return

func windows_crash_fix():
	Blackboard.actors.clear()
	Blackboard.current_world = self
	
	if not Global.is_iid_persistent:
		Global.reset_iid_table()
	
	self.add_to_group("Worlds")
	return
